/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.CacheDao;
import org.smallmind.persistence.cache.CacheDomain;
import org.smallmind.persistence.cache.DurableKey;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.PersistenceCache;
import org.smallmind.persistence.cache.VectorKey;

public abstract class AbstractCacheDao<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements CacheDao<I, D> {
    private CacheDomain<I, D> cacheDomain;

    public AbstractCacheDao(CacheDomain<I, D> cacheDomain) {
        this.cacheDomain = cacheDomain;
    }

    @Override
    public String getMetricSource() {
        return this.cacheDomain.getMetricSource();
    }

    @Override
    public PersistenceCache<String, D> getInstanceCache(Class<D> durableClass) {
        return this.cacheDomain.getInstanceCache(durableClass);
    }

    @Override
    public PersistenceCache<String, DurableVector<I, D>> getVectorCache(Class<D> durableClass) {
        return this.cacheDomain.getVectorCache(durableClass);
    }

    @Override
    public D get(Class<D> durableClass, I id) {
        DurableKey<I, D> durableKey = new DurableKey<I, D>(durableClass, id);
        return (D)((Durable)this.getInstanceCache(durableClass).get(durableKey.getKey()));
    }

    @Override
    public Map<DurableKey<I, D>, D> get(Class<D> durableClass, List<DurableKey<I, D>> durableKeys) {
        HashMap<DurableKey, Durable> resultMap = new HashMap<DurableKey, Durable>();
        if (durableKeys != null && !durableKeys.isEmpty()) {
            HashMap<String, DurableKey<I, D>> durableKeyMap = new HashMap<String, DurableKey<I, D>>();
            String[] keys = new String[durableKeys.size()];
            int index = 0;
            for (DurableKey<I, D> durableKey : durableKeys) {
                keys[index] = durableKey.getKey();
                durableKeyMap.put(keys[index++], durableKey);
            }
            Map<String, D> valueMap = this.getInstanceCache(durableClass).get((String[])keys);
            if (valueMap != null) {
                for (Map.Entry entry : valueMap.entrySet()) {
                    resultMap.put((DurableKey)durableKeyMap.get(entry.getKey()), (Durable)entry.getValue());
                }
            }
        }
        return resultMap;
    }

    @Override
    public void delete(Class<D> durableClass, D durable) {
        if (durable != null) {
            DurableKey durableKey = new DurableKey(durableClass, durable.getId());
            this.getInstanceCache(durableClass).remove(durableKey.getKey());
        }
    }

    @Override
    public DurableVector<I, D> getVector(VectorKey<D> vectorKey) {
        return this.getVectorCache(vectorKey.getElementClass()).get(vectorKey.getKey());
    }

    @Override
    public DurableVector<I, D> persistVector(VectorKey<D> vectorKey, DurableVector<I, D> vector) {
        DurableVector<I, D> migratedVector = this.migrateVector(vectorKey.getElementClass(), vector);
        DurableVector<I, D> cachedVector = this.getVectorCache(vectorKey.getElementClass()).putIfAbsent(vectorKey.getKey(), migratedVector, migratedVector.getTimeToLiveSeconds());
        return cachedVector != null ? cachedVector : vector;
    }

    @Override
    public void deleteVector(VectorKey<D> vectorKey) {
        this.getVectorCache(vectorKey.getElementClass()).remove(vectorKey.getKey());
    }
}

