/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache;

import java.io.Serializable;
import java.util.List;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.CacheDomain;
import org.smallmind.persistence.cache.PersistenceCache;
import org.smallmind.persistence.cache.WideCacheDao;
import org.smallmind.persistence.cache.WideDurableKey;

public abstract class AbstractWideCacheDao<W extends Serializable & Comparable<W>, I extends Serializable & Comparable<I>, D extends Durable<I>>
implements WideCacheDao<W, I, D> {
    private CacheDomain<I, D> cacheDomain;

    public AbstractWideCacheDao(CacheDomain<I, D> cacheDomain) {
        this.cacheDomain = cacheDomain;
    }

    @Override
    public String getMetricSource() {
        return this.cacheDomain.getMetricSource();
    }

    @Override
    public PersistenceCache<String, List> getWideInstanceCache(Class<D> durableClass) {
        return this.cacheDomain.getWideInstanceCache(durableClass);
    }

    @Override
    public List<D> get(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass) {
        WideDurableKey<W, D> wideDurableKey = new WideDurableKey<W, D>(context, parentClass, parentId, durableClass);
        return this.getWideInstanceCache(durableClass).get(wideDurableKey.getKey());
    }

    @Override
    public void delete(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass) {
        WideDurableKey<W, D> wideDurableKey = new WideDurableKey<W, D>(context, parentClass, parentId, durableClass);
        this.getWideInstanceCache(durableClass).remove(wideDurableKey.getKey());
    }
}

