/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache;

import java.io.Serializable;
import org.smallmind.persistence.Durable;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class DurableKey<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements Serializable {
    private Class<D> durableClass;
    private String key;

    public DurableKey(Class<D> durableClass, I id) {
        this.durableClass = durableClass;
        StringBuilder keyBuilder = new StringBuilder(durableClass.getSimpleName());
        keyBuilder.append('=');
        keyBuilder.append(id);
        this.key = keyBuilder.toString();
    }

    public Class<D> getDurableClass() {
        return this.durableClass;
    }

    public String getKey() {
        return this.key;
    }

    public String getIdAsString() {
        return this.key.substring(this.key.indexOf(61) + 1);
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DurableKey && this.key.equals(((DurableKey)obj).getKey());
    }
}

