/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.smallmind.persistence.Durable;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public abstract class DurableVector<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements Serializable,
Iterable<D> {
    private Comparator<D> comparator;
    private boolean ordered;
    private long creationTimeMilliseconds;
    private int timeToLiveSeconds;
    private int maxSize;

    public DurableVector(Comparator<D> comparator, int maxSize, int timeToLiveSeconds, boolean ordered) {
        this.comparator = comparator;
        this.maxSize = maxSize;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.ordered = ordered;
        this.creationTimeMilliseconds = System.currentTimeMillis();
    }

    public abstract DurableVector<I, D> copy();

    public abstract boolean isSingular();

    public abstract boolean add(D var1);

    public abstract boolean remove(D var1);

    public abstract D head();

    public abstract List<D> asBestEffortLazyList();

    public List<D> asBestEffortPreFetchedList() {
        return this.asBestEffortLazyList();
    }

    public Comparator<D> getComparator() {
        return this.comparator;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isAlive() {
        return this.timeToLiveSeconds <= 0 || (System.currentTimeMillis() - this.creationTimeMilliseconds) / 1000L <= (long)this.timeToLiveSeconds;
    }
}

