/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache;

import java.io.Serializable;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.VectorArtifact;
import org.smallmind.persistence.cache.VectorIndex;
import org.smallmind.persistence.cache.aop.CachedWith;
import org.smallmind.persistence.cache.aop.Classifications;
import org.smallmind.persistence.cache.aop.Vector;
import org.smallmind.persistence.cache.aop.VectorCalculator;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class VectorKey<D extends Durable>
implements Serializable {
    private Class<D> elementClass;
    private String key;

    public VectorKey(Vector vector, D durable, Class<D> elementClass) {
        this(VectorCalculator.getVectorArtifact(vector, durable), elementClass, Classifications.get(CachedWith.class, null, vector));
    }

    public VectorKey(VectorArtifact vectorArtifact, Class<D> elementClass) {
        this(vectorArtifact, elementClass, null);
    }

    public VectorKey(VectorArtifact vectorArtifact, Class<D> elementClass, String classification) {
        this.elementClass = elementClass;
        this.key = this.buildKey(vectorArtifact, classification);
    }

    public String getKey() {
        return this.key;
    }

    public Class<D> getElementClass() {
        return this.elementClass;
    }

    private String buildKey(VectorArtifact vectorArtifact, String classification) {
        boolean indexed = false;
        StringBuilder keyBuilder = new StringBuilder(this.elementClass.getSimpleName());
        keyBuilder.append(':').append(vectorArtifact.getVectorNamespace());
        keyBuilder.append('[');
        VectorIndex[] vectorIndexArray = vectorArtifact.getVectorIndices();
        int n = vectorIndexArray.length;
        int n2 = 0;
        while (n2 < n) {
            VectorIndex index = vectorIndexArray[n2];
            if (indexed) {
                keyBuilder.append(',');
            }
            keyBuilder.append(index.getIndexAlias().length() > 0 ? index.getIndexAlias() : index.getIndexField()).append('=').append(index.getIndexValue() == null ? "null" : index.getIndexValue());
            indexed = true;
            ++n2;
        }
        keyBuilder.append(']');
        if (classification != null) {
            keyBuilder.append(classification);
        }
        return keyBuilder.toString();
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof VectorKey && this.key.equals(((VectorKey)obj).getKey());
    }
}

