/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache;

import java.io.Serializable;
import org.smallmind.persistence.Durable;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class WideDurableKey<W extends Serializable & Comparable<W>, D extends Durable<?>>
implements Serializable {
    private Class<D> durableClass;
    private String key;

    public WideDurableKey(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass) {
        this.durableClass = durableClass;
        StringBuilder keyBuilder = new StringBuilder(context);
        keyBuilder.append('.').append(parentClass.getSimpleName()).append('[').append(durableClass.getSimpleName()).append(']').append('=').append(parentId);
        this.key = keyBuilder.toString();
    }

    public Class<D> getDurableClass() {
        return this.durableClass;
    }

    public String getKey() {
        return this.key;
    }

    public String getParentIdAsString() {
        return this.key.substring(this.key.indexOf(61) + 1);
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof WideDurableKey && this.key.equals(((WideDurableKey)obj).getKey());
    }
}

