/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.aop;

import java.io.Serializable;
import java.util.Iterator;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.VectoredDao;

public class CacheCoherentIterable<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements Iterable<D> {
    private final Iterable<D> durableIterable;
    private final VectoredDao<I, D> vectoredDao;
    private final Class<D> durableClass;

    public CacheCoherentIterable(Iterable<D> durableIterable, Class<D> durableClass, VectoredDao<I, D> vectoredDao) {
        this.durableIterable = durableIterable;
        this.durableClass = durableClass;
        this.vectoredDao = vectoredDao;
    }

    @Override
    public Iterator<D> iterator() {
        return new CacheCoherentIterator(this.durableIterable.iterator());
    }

    private class CacheCoherentIterator
    implements Iterator<D> {
        private Iterator<D> durableIter;

        public CacheCoherentIterator(Iterator<D> durableIter) {
            this.durableIter = durableIter;
        }

        @Override
        public boolean hasNext() {
            return this.durableIter.hasNext();
        }

        @Override
        public D next() {
            return CacheCoherentIterable.this.vectoredDao.persist(CacheCoherentIterable.this.durableClass, (Durable)this.durableIter.next(), UpdateMode.SOFT);
        }

        @Override
        public void remove() {
            this.durableIter.remove();
        }
    }
}

