/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.aop;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.PersistenceManager;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.VectorKey;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.cache.aop.CacheAs;
import org.smallmind.persistence.cache.aop.CacheAutomationError;
import org.smallmind.persistence.cache.aop.Classifications;
import org.smallmind.persistence.cache.aop.VectorCalculator;
import org.smallmind.persistence.instrument.aop.Instrumented;
import org.smallmind.persistence.orm.ORMDao;

@Aspect
public class ORMBasedCacheAsAspect {
    private static final Random RANDOM = new SecureRandom();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ORMBasedCacheAsAspect ajc$perSingletonInstance;

    static {
        try {
            ORMBasedCacheAsAspect.ajc$perSingletonInstance = new ORMBasedCacheAsAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Around(value="execution(@CacheAs * * (..)) && @annotation(cacheAs) && this(ormDao)", argNames="thisJoinPoint, cacheAs, ormDao")
    public Object aroundCacheAsMethod(ProceedingJoinPoint thisJoinPoint, CacheAs cacheAs, ORMDao ormDao) throws Throwable {
        MethodSignature methodSignature;
        boolean timingEnabled;
        long start;
        String metricSource;
        Method executedMethod;
        block39: {
            block44: {
                List list;
                block45: {
                    DurableVector vector;
                    VectorKey vectorKey;
                    VectoredDao vectoredDao;
                    block42: {
                        List list2;
                        block43: {
                            block40: {
                                Object object;
                                block41: {
                                    block32: {
                                        block37: {
                                            Durable durable;
                                            block38: {
                                                VectorKey vectorKey2;
                                                VectoredDao vectoredDao2;
                                                block35: {
                                                    Object d;
                                                    block36: {
                                                        block33: {
                                                            Object object2;
                                                            block34: {
                                                                executedMethod = null;
                                                                metricSource = null;
                                                                start = 0L;
                                                                Instrumented instrumentedAnnotation = ormDao.getClass().getAnnotation(Instrumented.class);
                                                                timingEnabled = instrumentedAnnotation != null && instrumentedAnnotation.value();
                                                                if (timingEnabled) {
                                                                    start = System.currentTimeMillis();
                                                                }
                                                                methodSignature = (MethodSignature)thisJoinPoint.getSignature();
                                                                if (cacheAs.time().value() < 0L) {
                                                                    throw new CacheAutomationError("The base time(%d) value of a @CacheAs annotation can not be negative", cacheAs.time().value());
                                                                }
                                                                if (cacheAs.time().stochastic() < 0) {
                                                                    throw new CacheAutomationError("The stochastic(%d) attribute of a @CacheAs annotation can not be negative", cacheAs.time().stochastic());
                                                                }
                                                                if (!ormDao.getManagedClass().isAssignableFrom(methodSignature.getReturnType())) break block32;
                                                                if (cacheAs.ordered()) {
                                                                    throw new CacheAutomationError("A method annotated with @CacheAs which does not return an Iterable type can't be ordered", cacheAs.comparator().getClass().getName());
                                                                }
                                                                if (cacheAs.max() > 0) {
                                                                    throw new CacheAutomationError("A method annotated with @CacheAs which does not return an Iterable type may not define a maximum size", cacheAs.comparator().getClass().getName());
                                                                }
                                                                if (!cacheAs.comparator().equals(Comparator.class)) {
                                                                    throw new CacheAutomationError("A method annotated with @CacheAs which does not return an Iterable type can not register a comparator(%s)", cacheAs.comparator().getClass().getName());
                                                                }
                                                                vectoredDao2 = ormDao.getVectoredDao();
                                                                if (vectoredDao2 != null) break block33;
                                                                metricSource = ormDao.getMetricSource();
                                                                object2 = thisJoinPoint.proceed();
                                                                if (!timingEnabled) break block34;
                                                                long stop = System.currentTimeMillis();
                                                                if (executedMethod == null) {
                                                                    executedMethod = methodSignature.getMethod();
                                                                }
                                                                InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
                                                            }
                                                            return object2;
                                                        }
                                                        vectorKey2 = new VectorKey(VectorCalculator.getVectorArtifact(cacheAs.value(), (JoinPoint)thisJoinPoint), ormDao.getManagedClass(), Classifications.get(CacheAs.class, (JoinPoint)thisJoinPoint, cacheAs.value()));
                                                        DurableVector vector2 = vectoredDao2.getVector(vectorKey2);
                                                        if (vector2 == null) break block35;
                                                        if (!vector2.isAlive()) {
                                                            vectoredDao2.deleteVector(vectorKey2);
                                                            break block35;
                                                        }
                                                        metricSource = vectoredDao2.getMetricSource();
                                                        d = vector2.head();
                                                        if (!timingEnabled) break block36;
                                                        long stop = System.currentTimeMillis();
                                                        if (executedMethod == null) {
                                                            executedMethod = methodSignature.getMethod();
                                                        }
                                                        InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
                                                    }
                                                    return d;
                                                }
                                                metricSource = ormDao.getMetricSource();
                                                Durable durable2 = (Durable)thisJoinPoint.proceed();
                                                if (durable2 == null) break block37;
                                                durable = vectoredDao2.persistVector(vectorKey2, vectoredDao2.createSingularVector(vectorKey2, durable2, this.getTimeToLiveSeconds(cacheAs))).head();
                                                if (!timingEnabled) break block38;
                                                long stop = System.currentTimeMillis();
                                                if (executedMethod == null) {
                                                    executedMethod = methodSignature.getMethod();
                                                }
                                                InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
                                            }
                                            return durable;
                                        }
                                        if (timingEnabled) {
                                            long stop = System.currentTimeMillis();
                                            if (executedMethod == null) {
                                                executedMethod = methodSignature.getMethod();
                                            }
                                            InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
                                        }
                                        return null;
                                    }
                                    if (!Iterable.class.isAssignableFrom(methodSignature.getReturnType())) break block39;
                                    if (!cacheAs.comparator().equals(Comparator.class) && !cacheAs.ordered()) {
                                        throw new CacheAutomationError("A method annotated with @CacheAs has registered a comparator(%s) but is not ordered", cacheAs.comparator().getClass().getName());
                                    }
                                    executedMethod = methodSignature.getMethod();
                                    Type returnType = executedMethod.getGenericReturnType();
                                    if (!(returnType instanceof ParameterizedType) || !ormDao.getManagedClass().isAssignableFrom((Class)((ParameterizedType)returnType).getActualTypeArguments()[0])) {
                                        throw new CacheAutomationError("Methods annotated with @CacheAs which return an Iterable type must be parameterized to <? extends Iterable<? extends %s>>", ormDao.getManagedClass().getSimpleName());
                                    }
                                    vectoredDao = ormDao.getVectoredDao();
                                    if (vectoredDao != null) break block40;
                                    metricSource = ormDao.getMetricSource();
                                    object = thisJoinPoint.proceed();
                                    if (!timingEnabled) break block41;
                                    long stop = System.currentTimeMillis();
                                    if (executedMethod == null) {
                                        executedMethod = methodSignature.getMethod();
                                    }
                                    InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
                                }
                                return object;
                            }
                            vectorKey = new VectorKey(VectorCalculator.getVectorArtifact(cacheAs.value(), (JoinPoint)thisJoinPoint), ormDao.getManagedClass(), Classifications.get(CacheAs.class, (JoinPoint)thisJoinPoint, cacheAs.value()));
                            vector = vectoredDao.getVector(vectorKey);
                            if (vector == null) break block42;
                            if (!vector.isAlive()) {
                                vectoredDao.deleteVector(vectorKey);
                                break block42;
                            }
                            metricSource = vectoredDao.getMetricSource();
                            List list3 = list2 = List.class.isAssignableFrom(methodSignature.getReturnType()) ? vector.asBestEffortPreFetchedList() : vector.asBestEffortLazyList();
                            if (!timingEnabled) break block43;
                            long stop = System.currentTimeMillis();
                            if (executedMethod == null) {
                                executedMethod = methodSignature.getMethod();
                            }
                            InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
                        }
                        return list2;
                    }
                    metricSource = ormDao.getMetricSource();
                    Iterable iterable = (Iterable)thisJoinPoint.proceed();
                    if (iterable == null) break block44;
                    vector = vectoredDao.persistVector(vectorKey, vectoredDao.createVector(vectorKey, iterable, cacheAs.comparator().equals(Comparator.class) ? null : cacheAs.comparator().newInstance(), cacheAs.max(), this.getTimeToLiveSeconds(cacheAs), cacheAs.ordered()));
                    List list4 = list = List.class.isAssignableFrom(methodSignature.getReturnType()) ? vector.asBestEffortPreFetchedList() : vector.asBestEffortLazyList();
                    if (!timingEnabled) break block45;
                    long stop = System.currentTimeMillis();
                    if (executedMethod == null) {
                        executedMethod = methodSignature.getMethod();
                    }
                    InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
                }
                return list;
            }
            if (timingEnabled) {
                long stop = System.currentTimeMillis();
                if (executedMethod == null) {
                    executedMethod = methodSignature.getMethod();
                }
                InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
            }
            return null;
        }
        try {
            try {
                throw new CacheAutomationError("Methods annotated with @CacheAs must either return their managed type(%s), or an Iterable parameterized to their managed type <? extends Iterable<? extends %s>>", ormDao.getManagedClass().getSimpleName(), ormDao.getManagedClass().getSimpleName());
            }
            catch (Throwable throwable) {
                timingEnabled = false;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (timingEnabled) {
                long stop = System.currentTimeMillis();
                if (executedMethod == null) {
                    executedMethod = methodSignature.getMethod();
                }
                InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PersistenceManager.getPersistence(), (long)(stop - start), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("durable", ormDao.getManagedClass().getSimpleName()), new MetricProperty("method", executedMethod.getName()), new MetricProperty("source", metricSource)});
            }
            throw throwable;
        }
    }

    private int getTimeToLiveSeconds(CacheAs cacheAs) {
        if (cacheAs.time().value() == 0L && cacheAs.time().stochastic() == 0) {
            return 0;
        }
        int baseTime = (int)cacheAs.time().unit().toSeconds(cacheAs.time().value());
        if (cacheAs.time().stochastic() > 0) {
            baseTime = (int)((double)baseTime + ((double)cacheAs.time().unit().toSeconds(cacheAs.time().stochastic()) * RANDOM.nextDouble() + 1.0));
        }
        return baseTime;
    }

    public static ORMBasedCacheAsAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.smallmind.persistence.cache.aop.ORMBasedCacheAsAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

