/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.util.SingleItemIterable;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.VectorKey;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.cache.aop.CacheAutomationError;
import org.smallmind.persistence.cache.aop.CachedWith;
import org.smallmind.persistence.cache.aop.Classifications;
import org.smallmind.persistence.cache.aop.Finder;
import org.smallmind.persistence.cache.aop.OnPersist;
import org.smallmind.persistence.cache.aop.Proxy;
import org.smallmind.persistence.cache.aop.Update;
import org.smallmind.persistence.cache.aop.VectorCalculator;
import org.smallmind.persistence.orm.ORMDao;

@Aspect
public class ORMBasedCachedWithAspect {
    private static final ConcurrentHashMap<MethodKey, Method> METHOD_MAP = new ConcurrentHashMap();
    private static /* synthetic */ int[] $SWITCH_TABLE$org$smallmind$persistence$cache$aop$OnPersist;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ORMBasedCachedWithAspect ajc$perSingletonInstance;

    static {
        try {
            ORMBasedCachedWithAspect.ajc$perSingletonInstance = new ORMBasedCachedWithAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Around(value="(execution(* persist (org.smallmind.persistence.Durable+)) || execution(@Persist * * (org.smallmind.persistence.Durable+))) && @within(CachedWith) && this(ormDao)", argNames="thisJoinPoint, ormDao")
    public Object aroundPersistMethod(ProceedingJoinPoint thisJoinPoint, ORMDao ormDao) throws Throwable {
        CachedWith cachedWith;
        VectoredDao vectoredDao = ormDao.getVectoredDao();
        if (vectoredDao == null || (cachedWith = ormDao.getClass().getAnnotation(CachedWith.class)) == null) {
            return thisJoinPoint.proceed();
        }
        Durable durable = (Durable)thisJoinPoint.proceed();
        if (durable == null) {
            return thisJoinPoint.proceed();
        }
        Annotation[] annotationArray = cachedWith.updates();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Update update = annotationArray[n2];
            if (this.executeFilter(update.filter(), ormDao, durable)) {
                OnPersist onPersist = this.executeOnPersist(update.onPersist(), ormDao, durable);
                Iterable finderIterable = this.executeFinder(update.finder(), ormDao, durable);
                for (Durable indexingDurable : finderIterable) {
                    Operand operand = this.executeProxy(update.proxy(), ormDao, indexingDurable);
                    switch (ORMBasedCachedWithAspect.$SWITCH_TABLE$org$smallmind$persistence$cache$aop$OnPersist()[onPersist.ordinal()]) {
                        case 1: {
                            vectoredDao.updateInVector(new VectorKey(VectorCalculator.getVectorArtifact(update.value(), operand.getDurable()), ormDao.getManagedClass(), Classifications.get(CachedWith.class, null, update.value())), indexingDurable);
                            break;
                        }
                        case 2: {
                            vectoredDao.removeFromVector(new VectorKey(VectorCalculator.getVectorArtifact(update.value(), operand.getDurable()), ormDao.getManagedClass(), Classifications.get(CachedWith.class, null, update.value())), indexingDurable);
                            break;
                        }
                        default: {
                            throw new UnknownSwitchCaseException(onPersist.name(), new Object[0]);
                        }
                    }
                }
            }
            ++n2;
        }
        annotationArray = cachedWith.invalidates();
        n = annotationArray.length;
        n2 = 0;
        while (n2 < n) {
            Annotation invalidate = annotationArray[n2];
            if (this.executeFilter(invalidate.filter(), ormDao, durable)) {
                Iterable finderIterable = this.executeFinder(invalidate.finder(), ormDao, durable);
                for (Durable indexingDurable : finderIterable) {
                    Operand operand = this.executeProxy(invalidate.proxy(), ormDao, indexingDurable);
                    vectoredDao.deleteVector(new VectorKey(VectorCalculator.getVectorArtifact(invalidate.value(), operand.getDurable()), ormDao.getManagedClass(), Classifications.get(CachedWith.class, null, invalidate.value())));
                }
            }
            ++n2;
        }
        return durable;
    }

    @Around(value="(execution(void delete (..)) || execution(@Delete * * (..))) && @within(CachedWith) && args(durable) && this(ormDao)", argNames="thisJoinPoint, ormDao, durable")
    public void aroundDeleteMethod(ProceedingJoinPoint thisJoinPoint, ORMDao ormDao, Durable durable) throws Throwable {
        CachedWith cachedWith;
        VectoredDao vectoredDao = ormDao.getVectoredDao();
        if (vectoredDao == null || (cachedWith = ormDao.getClass().getAnnotation(CachedWith.class)) == null || durable == null) {
            thisJoinPoint.proceed();
        } else {
            Operand operand;
            Iterable finderIterable;
            thisJoinPoint.proceed();
            Annotation[] annotationArray = cachedWith.updates();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Update update = annotationArray[n2];
                if (this.executeFilter(update.filter(), ormDao, durable)) {
                    finderIterable = this.executeFinder(update.finder(), ormDao, durable);
                    for (Durable indexingDurable : finderIterable) {
                        operand = this.executeProxy(update.proxy(), ormDao, indexingDurable);
                        vectoredDao.removeFromVector(new VectorKey(VectorCalculator.getVectorArtifact(update.value(), operand.getDurable()), ormDao.getManagedClass(), Classifications.get(CachedWith.class, null, update.value())), indexingDurable);
                    }
                }
                ++n2;
            }
            annotationArray = cachedWith.invalidates();
            n = annotationArray.length;
            n2 = 0;
            while (n2 < n) {
                Annotation invalidate = annotationArray[n2];
                if (this.executeFilter(invalidate.filter(), ormDao, durable)) {
                    finderIterable = this.executeFinder(invalidate.finder(), ormDao, durable);
                    for (Durable indexingDurable : finderIterable) {
                        operand = this.executeProxy(invalidate.proxy(), ormDao, indexingDurable);
                        vectoredDao.deleteVector(new VectorKey(VectorCalculator.getVectorArtifact(invalidate.value(), operand.getDurable()), ormDao.getManagedClass(), Classifications.get(CachedWith.class, null, invalidate.value())));
                    }
                }
                ++n2;
            }
        }
    }

    private boolean executeFilter(String filterMethodName, ORMDao ormDao, Durable durable) {
        if (filterMethodName.length() > 0) {
            Method filterMethod = this.locateMethod(ormDao, filterMethodName, ormDao.getManagedClass());
            if (filterMethod == null) {
                throw new CacheAutomationError("The filter Method(%s) referenced within @CachedWith does not exist", filterMethodName);
            }
            if (!filterMethod.getReturnType().equals(Boolean.TYPE) && !filterMethod.getReturnType().equals(Boolean.class)) {
                throw new CacheAutomationError("A filter Method(%s) referenced by @CachedWith must return a value of type 'boolean'", filterMethodName);
            }
            try {
                return (Boolean)filterMethod.invoke((Object)ormDao, durable);
            }
            catch (Exception exception) {
                throw new CacheAutomationError(exception);
            }
        }
        return true;
    }

    private OnPersist executeOnPersist(String onPersistMethodName, ORMDao ormDao, Durable durable) {
        if (onPersistMethodName.length() > 0) {
            Method onPersistMethod = this.locateMethod(ormDao, onPersistMethodName, ormDao.getManagedClass());
            if (onPersistMethod == null) {
                throw new CacheAutomationError("The onPersist Method(%s) referenced within @CachedWith does not exist", onPersistMethodName);
            }
            if (!onPersistMethod.getReturnType().equals(OnPersist.class)) {
                throw new CacheAutomationError("An onPersist Method(%s) referenced by @CachedWith must return a value of type 'OnPersist'", onPersistMethodName);
            }
            try {
                return (OnPersist)((Object)onPersistMethod.invoke((Object)ormDao, durable));
            }
            catch (Exception exception) {
                throw new CacheAutomationError(exception);
            }
        }
        return OnPersist.INSERT;
    }

    private Operand executeProxy(Proxy proxy, ORMDao ormDao, Durable durable) {
        if (proxy.method() == null || proxy.method().length() == 0) {
            return new Operand(ormDao.getManagedClass(), durable);
        }
        Method proxyMethod = this.locateMethod(ormDao, proxy.method(), ormDao.getManagedClass());
        if (proxyMethod == null) {
            throw new CacheAutomationError("The proxy method(%s) does not exist", proxy.method());
        }
        Class<Object> expectedType = proxy.with().equals(Durable.class) ? durable.getClass() : proxy.with();
        if (!expectedType.isAssignableFrom(proxyMethod.getReturnType())) {
            throw new CacheAutomationError("The proxy method(%s) must return a %s type", proxy.method(), expectedType);
        }
        try {
            return new Operand(expectedType, (Durable)proxyMethod.invoke((Object)ormDao, durable));
        }
        catch (Exception exception) {
            throw new CacheAutomationError(exception);
        }
    }

    private Iterable<Durable> executeFinder(Finder finder, ORMDao ormDao, Durable durable) {
        if (finder.method() == null || finder.method().length() == 0) {
            return new SingleItemIterable((Object)durable);
        }
        Method finderMethod = this.locateMethod(ormDao, finder.method(), ormDao.getManagedClass());
        if (finderMethod == null) {
            throw new CacheAutomationError("The finder method(%s) does not exist", finder.method());
        }
        Class<Object> expectedType = finder.with().equals(Durable.class) ? durable.getClass() : finder.with();
        if (expectedType.isAssignableFrom(finderMethod.getReturnType())) {
            try {
                return new SingleItemIterable((Object)((Durable)finderMethod.invoke((Object)ormDao, durable)));
            }
            catch (Exception exception) {
                throw new CacheAutomationError(exception);
            }
        }
        if (!Iterable.class.isAssignableFrom(finderMethod.getReturnType())) {
            Type finderReturnType = finderMethod.getGenericReturnType();
            if (!(finderReturnType instanceof ParameterizedType) || !expectedType.isAssignableFrom((Class)((ParameterizedType)finderReturnType).getActualTypeArguments()[0])) {
                throw new CacheAutomationError("The finder method(%s) must return an Iterable parameterized to %s <? extends Iterable<? extends %s>>", finder.method(), expectedType.getSimpleName(), expectedType.getSimpleName());
            }
            try {
                return (Iterable)finderMethod.invoke((Object)ormDao, durable);
            }
            catch (Exception exception) {
                throw new CacheAutomationError(exception);
            }
        }
        throw new CacheAutomationError("The finder method(%s) must return either a %s type, or an Iterable parameterized to %s <? extends Iterable<? extends %s>>", finder.method(), expectedType.getSimpleName(), expectedType.getSimpleName(), expectedType.getSimpleName());
    }

    private Method locateMethod(ORMDao ormDao, String methodName, Class parameterType) {
        MethodKey methodKey = new MethodKey(ormDao.getClass(), methodName);
        Method aspectMethod = METHOD_MAP.get(methodKey);
        if (aspectMethod == null) {
            Method[] methodArray = ormDao.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] parameterTypes;
                Method method = methodArray[n2];
                if (method.getName().equals(methodName) && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0].isAssignableFrom(parameterType)) {
                    aspectMethod = method;
                    METHOD_MAP.put(methodKey, aspectMethod);
                    break;
                }
                ++n2;
            }
        }
        return aspectMethod;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$smallmind$persistence$cache$aop$OnPersist() {
        if ($SWITCH_TABLE$org$smallmind$persistence$cache$aop$OnPersist != null) {
            return $SWITCH_TABLE$org$smallmind$persistence$cache$aop$OnPersist;
        }
        int[] nArray = new int[OnPersist.values().length];
        try {
            nArray[OnPersist.INSERT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OnPersist.REMOVE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$smallmind$persistence$cache$aop$OnPersist = nArray;
        return nArray;
    }

    public static ORMBasedCachedWithAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.smallmind.persistence.cache.aop.ORMBasedCachedWithAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public class MethodKey {
        private Class methodClass;
        private String methodName;

        private MethodKey(Class methodClass, String methodName) {
            this.methodClass = methodClass;
            this.methodName = methodName;
        }

        public Class getMethodClass() {
            return this.methodClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int hashCode() {
            return this.methodClass.hashCode() ^ this.methodName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof MethodKey && this.methodClass.equals(((MethodKey)obj).getMethodClass()) && this.methodName.equals(((MethodKey)obj).getMethodName());
        }
    }

    public class Operand {
        private Class<? extends Durable> managedClass;
        private Durable durable;

        private Operand(Class<? extends Durable> managedClass, Durable durable) {
            this.managedClass = managedClass;
            this.durable = durable;
        }

        public Class<? extends Durable> getManagedClass() {
            return this.managedClass;
        }

        public Durable getDurable() {
            return this.durable;
        }
    }
}

