/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.memcached;

import java.util.Arrays;
import java.util.Map;
import org.smallmind.memcached.ProxyCASResponse;
import org.smallmind.memcached.ProxyMemcachedClient;
import org.smallmind.persistence.cache.CASSupportingPersistenceCache;
import org.smallmind.persistence.cache.CASValue;
import org.smallmind.persistence.cache.CacheOperationException;

public class MemcachedCache<V>
implements CASSupportingPersistenceCache<String, V> {
    private ProxyMemcachedClient memcachedClient;
    private Class<V> valueClass;
    private String discriminator;
    private int timeToLiveSeconds;

    public MemcachedCache(ProxyMemcachedClient memcachedClient, String discriminator, Class<V> valueClass, int timeToLiveSeconds) {
        this.valueClass = valueClass;
        this.memcachedClient = memcachedClient;
        this.discriminator = discriminator;
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public ProxyMemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    @Override
    public boolean requiresCopyOnDistributedCASOperation() {
        return false;
    }

    @Override
    public int getDefaultTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    @Override
    public V get(String key) throws CacheOperationException {
        try {
            return this.valueClass.cast(this.memcachedClient.get(this.getDiscriminatedKey(key)));
        }
        catch (Exception exception) {
            throw new CacheOperationException(exception);
        }
    }

    @Override
    public Map<String, V> get(String[] keys) throws CacheOperationException {
        String[] discriminatedKeys = new String[keys.length];
        int index = 0;
        while (index < keys.length) {
            discriminatedKeys[index] = this.getDiscriminatedKey(keys[index]);
            ++index;
        }
        try {
            return this.memcachedClient.get(Arrays.asList(discriminatedKeys));
        }
        catch (Exception exception) {
            throw new CacheOperationException(exception);
        }
    }

    @Override
    public void set(String key, V value, int timeToLiveSeconds) {
        try {
            this.memcachedClient.set(this.getDiscriminatedKey(key), timeToLiveSeconds <= 0 ? this.getDefaultTimeToLiveSeconds() : timeToLiveSeconds, value);
        }
        catch (Exception exception) {
            throw new CacheOperationException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V putIfAbsent(String key, V value, int timeToLiveSeconds) {
        try {
            String discriminatedKey = this.getDiscriminatedKey(key);
            ProxyCASResponse getsResponse = this.memcachedClient.casGet(discriminatedKey);
            if (getsResponse != null && getsResponse.getValue() != null) {
                return (V)getsResponse.getValue();
            }
            while (!this.memcachedClient.casSet(discriminatedKey, timeToLiveSeconds <= 0 ? this.getDefaultTimeToLiveSeconds() : timeToLiveSeconds, value, 0L)) {
                getsResponse = this.memcachedClient.casGet(discriminatedKey);
                if (getsResponse == null || getsResponse.getValue() == null) continue;
                return (V)getsResponse.getValue();
            }
            return null;
        }
        catch (Exception exception) {
            throw new CacheOperationException(exception);
        }
    }

    @Override
    public CASValue<V> getViaCas(String key) {
        try {
            ProxyCASResponse getsResponse = this.memcachedClient.casGet(this.getDiscriminatedKey(key));
            if (getsResponse == null) {
                return CASValue.nullInstance();
            }
            return new CASValue<Object>(getsResponse.getValue(), getsResponse.getCas());
        }
        catch (Exception exception) {
            throw new CacheOperationException(exception);
        }
    }

    @Override
    public boolean putViaCas(String key, V oldValue, V value, long version, int timeToLiveSeconds) {
        try {
            return this.memcachedClient.casSet(this.getDiscriminatedKey(key), timeToLiveSeconds <= 0 ? this.getDefaultTimeToLiveSeconds() : timeToLiveSeconds, value, version);
        }
        catch (Exception exception) {
            throw new CacheOperationException(exception);
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.memcachedClient.delete(this.getDiscriminatedKey(key));
        }
        catch (Exception exception) {
            throw new CacheOperationException(exception);
        }
    }

    private String getDiscriminatedKey(String key) {
        return this.discriminator + '[' + key + ']';
    }
}

