/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.memcached;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.memcached.ProxyMemcachedClient;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.MetricSource;
import org.smallmind.persistence.cache.CacheDomain;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.PersistenceCache;
import org.smallmind.persistence.cache.memcached.MemcachedCache;

public class MemcachedCacheDomain<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements CacheDomain<I, D> {
    private final ProxyMemcachedClient memcachedClient;
    private final Map<Class<D>, Integer> timeTiLiveOverrideMap;
    private final ConcurrentHashMap<Class<D>, MemcachedCache<D>> instanceCacheMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<D>, MemcachedCache<List>> wideInstanceCacheMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<D>, MemcachedCache<DurableVector<I, D>>> vectorCacheMap = new ConcurrentHashMap();
    private final String discriminator;
    private final int timeToLiveSeconds;

    public MemcachedCacheDomain(ProxyMemcachedClient memcachedClient, String discriminator, int timeToLiveSeconds) {
        this(memcachedClient, discriminator, timeToLiveSeconds, null);
    }

    public MemcachedCacheDomain(ProxyMemcachedClient memcachedClient, String discriminator, int timeToLiveSeconds, Map<Class<D>, Integer> timeTiLiveOverrideMap) {
        this.memcachedClient = memcachedClient;
        this.discriminator = discriminator;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeTiLiveOverrideMap = timeTiLiveOverrideMap;
    }

    @Override
    public String getMetricSource() {
        return MetricSource.MEMCACHED.getDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceCache<String, D> getInstanceCache(Class<D> managedClass) {
        MemcachedCache<D> instanceCache = this.instanceCacheMap.get(managedClass);
        if (instanceCache == null) {
            ConcurrentHashMap<Class<D>, MemcachedCache<D>> concurrentHashMap = this.instanceCacheMap;
            synchronized (concurrentHashMap) {
                instanceCache = this.instanceCacheMap.get(managedClass);
                if (instanceCache == null) {
                    instanceCache = new MemcachedCache<D>(this.memcachedClient, this.discriminator, managedClass, this.getTimeToLiveSeconds(managedClass));
                    this.instanceCacheMap.put(managedClass, instanceCache);
                }
            }
        }
        return instanceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceCache<String, List> getWideInstanceCache(Class<D> managedClass) {
        MemcachedCache<List> wideInstanceCache = this.wideInstanceCacheMap.get(managedClass);
        if (wideInstanceCache == null) {
            ConcurrentHashMap<Class<D>, MemcachedCache<List>> concurrentHashMap = this.wideInstanceCacheMap;
            synchronized (concurrentHashMap) {
                wideInstanceCache = this.wideInstanceCacheMap.get(managedClass);
                if (wideInstanceCache == null) {
                    wideInstanceCache = new MemcachedCache<List>(this.memcachedClient, this.discriminator, List.class, this.getTimeToLiveSeconds(managedClass));
                    this.wideInstanceCacheMap.put(managedClass, wideInstanceCache);
                }
            }
        }
        return wideInstanceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceCache<String, DurableVector<I, D>> getVectorCache(Class<D> managedClass) {
        MemcachedCache<DurableVector<I, D>> vectorCache = this.vectorCacheMap.get(managedClass);
        if (vectorCache == null) {
            ConcurrentHashMap<Class<D>, MemcachedCache<DurableVector<I, D>>> concurrentHashMap = this.vectorCacheMap;
            synchronized (concurrentHashMap) {
                vectorCache = this.vectorCacheMap.get(managedClass);
                if (vectorCache == null) {
                    vectorCache = new MemcachedCache<DurableVector>(this.memcachedClient, this.discriminator, DurableVector.class, this.getTimeToLiveSeconds(managedClass));
                    this.vectorCacheMap.put(managedClass, vectorCache);
                }
            }
        }
        return vectorCache;
    }

    private int getTimeToLiveSeconds(Class<D> managedClass) {
        Integer timeToLiveOverrideSeconds;
        if (this.timeTiLiveOverrideMap != null && (timeToLiveOverrideSeconds = this.timeTiLiveOverrideMap.get(managedClass)) != null) {
            return timeToLiveOverrideSeconds;
        }
        return this.timeToLiveSeconds;
    }
}

