/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.praxis.Roster;
import org.terracotta.annotations.AutolockRead;
import org.terracotta.annotations.AutolockWrite;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public abstract class AbstractDurableVector<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends DurableVector<I, D> {
    public AbstractDurableVector(Comparator<D> comparator, int maxSize, int timeToLiveSeconds, boolean ordered) {
        super(comparator, maxSize, timeToLiveSeconds, ordered);
    }

    public abstract Roster<D> getRoster();

    @Override
    public abstract DurableVector<I, D> copy();

    @Override
    public boolean isSingular() {
        return false;
    }

    @Override
    @AutolockWrite
    public synchronized boolean add(D durable) {
        boolean changed = false;
        if (durable != null) {
            if (this.isOrdered()) {
                Iterator rosterIter = this.getRoster().iterator();
                boolean matched = false;
                boolean zoned = false;
                boolean inserted = false;
                int index = 0;
                while (!(matched && zoned || !rosterIter.hasNext())) {
                    Durable element = (Durable)rosterIter.next();
                    if (element.equals(durable)) {
                        if ((this.getComparator() == null ? element.compareTo(durable) : this.getComparator().compare(element, durable)) == 0) {
                            zoned = true;
                            inserted = true;
                        } else {
                            changed = true;
                            rosterIter.remove();
                        }
                        matched = true;
                        continue;
                    }
                    if (!zoned && (this.getComparator() == null ? element.compareTo(durable) : this.getComparator().compare(element, durable)) >= 0) {
                        zoned = true;
                        continue;
                    }
                    if (zoned) continue;
                    ++index;
                }
                if (!inserted) {
                    changed = true;
                    this.getRoster().add(index, durable);
                }
            } else {
                boolean matched = false;
                for (Durable element : this.getRoster()) {
                    if (!element.equals(durable)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    changed = true;
                    this.getRoster().addFirst(durable);
                }
            }
            if (this.getMaxSize() > 0 && this.getRoster().size() > this.getMaxSize()) {
                changed = true;
                this.getRoster().removeLast();
            }
        }
        return changed;
    }

    @Override
    @AutolockWrite
    public synchronized boolean remove(D durable) {
        boolean removed;
        boolean changed = false;
        do {
            if (!(removed = this.getRoster().remove(durable))) continue;
            changed = true;
        } while (removed);
        return changed;
    }

    @Override
    @AutolockRead
    public synchronized D head() {
        if (this.getRoster().isEmpty()) {
            return null;
        }
        return (D)((Durable)this.getRoster().get(0));
    }
}

