/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.CacheOperationException;
import org.smallmind.persistence.cache.DurableKey;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.cache.praxis.ByKeyRosterIterator;
import org.smallmind.persistence.cache.praxis.Roster;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRoster;
import org.smallmind.persistence.orm.ORMDao;
import org.smallmind.persistence.orm.OrmDaoManager;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class ByKeyRoster<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements Roster<D> {
    private final Roster<DurableKey<I, D>> keyRoster;
    private final Class<D> durableClass;
    private volatile transient ORMDao<I, D, ?, ?> ormDao;

    public ByKeyRoster(Class<D> durableClass, Roster<DurableKey<I, D>> keyRoster) {
        this.durableClass = durableClass;
        this.keyRoster = keyRoster;
    }

    private ORMDao<I, D, ?, ?> getORMDao() {
        if (this.ormDao == null && (this.ormDao = OrmDaoManager.get(this.durableClass)) == null) {
            throw new CacheOperationException("Unable to locate an implementation of ORMDao within DaoManager for the requested durable(%s)", this.durableClass.getSimpleName());
        }
        return this.ormDao;
    }

    public List<D> prefetch() {
        ORMDao ormDao = this.getORMDao();
        VectoredDao<I, D> vectoredDao = ormDao.getVectoredDao();
        if (vectoredDao != null) {
            LinkedList<Durable> prefetchList = new LinkedList<Durable>();
            Map prefetchMap = vectoredDao.get(this.durableClass, (List<DurableKey<I, D>>)this.keyRoster);
            for (DurableKey durableKey : this.keyRoster) {
                Durable<Object> durable = (Durable)prefetchMap.get(durableKey);
                if (durable != null) {
                    prefetchList.add(durable);
                    continue;
                }
                durable = ormDao.acquire(this.durableClass, ormDao.getIdFromString(durableKey.getIdAsString()));
                if (durable == null) continue;
                prefetchList.add(durable);
            }
            return prefetchList;
        }
        return new LinkedList(this);
    }

    private D getDurable(DurableKey<I, D> durableKey) {
        if (durableKey == null) {
            return null;
        }
        D durable = this.getORMDao().get(this.getORMDao().getIdFromString(durableKey.getIdAsString()));
        if (durable == null) {
            throw new CacheOperationException("Unable to locate the requested durable(%s) instance(%s)", durableKey.getDurableClass().getSimpleName(), durableKey.getIdAsString());
        }
        return durable;
    }

    public Class<D> getDurableClass() {
        return this.durableClass;
    }

    public Roster<DurableKey<I, D>> getInternalRoster() {
        return this.keyRoster;
    }

    @Override
    public int size() {
        return this.keyRoster.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyRoster.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.durableClass.isAssignableFrom(obj.getClass()) && this.keyRoster.contains(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId()));
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T[])null);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] keyArray = this.keyRoster.toArray();
        int index = 0;
        T[] elements = a != null && a.length >= keyArray.length ? a : (Object[])Array.newInstance(a == null ? this.durableClass : a.getClass().getComponentType(), keyArray.length);
        Object[] objectArray = keyArray;
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            D durable = this.getDurable((DurableKey)key);
            if (durable != null) {
                elements[index++] = durable;
            }
            ++n2;
        }
        return elements;
    }

    @Override
    public D get(int index) {
        return this.getDurable((DurableKey)this.keyRoster.get(index));
    }

    @Override
    public D set(int index, D durable) {
        return this.getDurable(this.keyRoster.set(index, new DurableKey(this.durableClass, durable.getId())));
    }

    @Override
    public void addFirst(D durable) {
        this.keyRoster.addFirst(new DurableKey(this.durableClass, durable.getId()));
    }

    @Override
    public boolean add(D durable) {
        return this.keyRoster.add(new DurableKey(this.durableClass, durable.getId()));
    }

    @Override
    public void add(int index, D durable) {
        this.keyRoster.add(index, new DurableKey(this.durableClass, durable.getId()));
    }

    @Override
    public boolean remove(Object obj) {
        return this.durableClass.isAssignableFrom(obj.getClass()) && this.keyRoster.remove(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId()));
    }

    @Override
    public D removeLast() {
        return this.getDurable(this.keyRoster.removeLast());
    }

    @Override
    public D remove(int index) {
        return this.getDurable((DurableKey)this.keyRoster.remove(index));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        HashSet keySet = new HashSet();
        for (Object obj : c) {
            if (!this.durableClass.isAssignableFrom(obj.getClass())) {
                return false;
            }
            keySet.add(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId()));
        }
        return keySet.containsAll(keySet);
    }

    @Override
    public boolean addAll(Collection<? extends D> c) {
        HashSet keySet = new HashSet();
        for (D obj : c) {
            if (!this.durableClass.isAssignableFrom(obj.getClass())) continue;
            keySet.add(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId()));
        }
        return this.keyRoster.addAll(keySet);
    }

    @Override
    public boolean addAll(int index, Collection<? extends D> c) {
        HashSet keySet = new HashSet();
        for (D obj : c) {
            if (!this.durableClass.isAssignableFrom(obj.getClass())) continue;
            keySet.add(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId()));
        }
        return this.keyRoster.addAll(index, keySet);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet keySet = new HashSet();
        for (Object obj : c) {
            if (!this.durableClass.isAssignableFrom(obj.getClass())) continue;
            keySet.add(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId()));
        }
        return this.keyRoster.removeAll(keySet);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet keySet = new HashSet();
        for (Object obj : c) {
            if (!this.durableClass.isAssignableFrom(obj.getClass())) continue;
            keySet.add(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId()));
        }
        return this.keyRoster.retainAll(keySet);
    }

    @Override
    public void clear() {
        this.keyRoster.clear();
    }

    @Override
    public int indexOf(Object obj) {
        return this.durableClass.isAssignableFrom(obj.getClass()) ? this.keyRoster.indexOf(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId())) : -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.durableClass.isAssignableFrom(obj.getClass()) ? this.keyRoster.lastIndexOf(new DurableKey(this.durableClass, ((Durable)this.durableClass.cast(obj)).getId())) : -1;
    }

    @Override
    public Iterator<D> iterator() {
        return new ByKeyRosterIterator<I, D>(this.getORMDao(), this.keyRoster.listIterator());
    }

    @Override
    public ListIterator<D> listIterator() {
        return new ByKeyRosterIterator<I, D>(this.getORMDao(), this.keyRoster.listIterator());
    }

    @Override
    public ListIterator<D> listIterator(int index) {
        return new ByKeyRosterIterator<I, D>(this.getORMDao(), this.keyRoster.listIterator(index));
    }

    @Override
    public List<D> subList(int fromIndex, int toIndex) {
        return new ByKeyRoster<I, D>(this.durableClass, (IntrinsicRoster)this.keyRoster.subList(fromIndex, toIndex));
    }
}

