/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis;

import java.io.Serializable;
import java.util.ListIterator;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.CacheOperationException;
import org.smallmind.persistence.cache.DurableKey;
import org.smallmind.persistence.orm.ORMDao;

public class ByKeyRosterIterator<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements ListIterator<D> {
    private final ORMDao<I, D, ?, ?> ormDao;
    private final ListIterator<DurableKey<I, D>> keyListIterator;

    public ByKeyRosterIterator(ORMDao<I, D, ?, ?> ormDao, ListIterator<DurableKey<I, D>> keyListIterator) {
        this.ormDao = ormDao;
        this.keyListIterator = keyListIterator;
    }

    private D getDurable(DurableKey<I, D> durableKey) {
        if (durableKey == null) {
            return null;
        }
        D durable = this.ormDao.get(this.ormDao.getIdFromString(durableKey.getIdAsString()));
        if (durable == null) {
            throw new CacheOperationException("Unable to locate the requested durable(%s) instance(%s)", durableKey.getDurableClass().getSimpleName(), durableKey.getIdAsString());
        }
        return durable;
    }

    @Override
    public boolean hasNext() {
        return this.keyListIterator.hasNext();
    }

    public DurableKey<I, D> nextKey() {
        return this.keyListIterator.next();
    }

    @Override
    public D next() {
        return this.getDurable(this.keyListIterator.next());
    }

    @Override
    public boolean hasPrevious() {
        return this.keyListIterator.hasPrevious();
    }

    @Override
    public D previous() {
        return this.getDurable(this.keyListIterator.previous());
    }

    @Override
    public int nextIndex() {
        return this.keyListIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.keyListIterator.previousIndex();
    }

    @Override
    public void remove() {
        this.keyListIterator.remove();
    }

    @Override
    public void set(D durable) {
        this.keyListIterator.set(new DurableKey(this.ormDao.getManagedClass(), durable.getId()));
    }

    @Override
    public void add(D durable) {
        this.keyListIterator.add(new DurableKey(this.ormDao.getManagedClass(), durable.getId()));
    }
}

