/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.smallmind.nutsnbolts.util.SingleItemIterable;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.CacheOperationException;
import org.smallmind.persistence.cache.DurableKey;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.orm.ORMDao;
import org.smallmind.persistence.orm.OrmDaoManager;
import org.terracotta.annotations.AutolockRead;
import org.terracotta.annotations.AutolockWrite;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class ByKeySingularVector<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends DurableVector<I, D> {
    private volatile transient ORMDao<I, D, ?, ?> ormDao;
    private DurableKey<I, D> durableKey;

    public ByKeySingularVector(DurableKey<I, D> durableKey, int timeToLiveSeconds) {
        super(null, 1, timeToLiveSeconds, false);
        this.durableKey = durableKey;
    }

    private ORMDao<I, D, ?, ?> getORMDao() {
        if (this.ormDao == null && (this.ormDao = OrmDaoManager.get(this.durableKey.getDurableClass())) == null) {
            throw new CacheOperationException("Unable to locate an implementation of ORMDao within DaoManager for the requested durable(%s)", this.durableKey.getDurableClass().getSimpleName());
        }
        return this.ormDao;
    }

    private D getDurable() {
        ORMDao ormDao = this.getORMDao();
        D durable = ormDao.get(ormDao.getIdFromString(this.durableKey.getIdAsString()));
        if (durable == null) {
            throw new CacheOperationException("Unable to locate the requested durable(%s) instance(%s)", this.durableKey.getDurableClass().getSimpleName(), this.durableKey.getIdAsString());
        }
        return durable;
    }

    @Override
    @AutolockRead
    public DurableVector<I, D> copy() {
        return new ByKeySingularVector<I, D>(this.durableKey, this.getTimeToLiveSeconds());
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    @AutolockWrite
    public synchronized boolean add(D durable) {
        if (!this.getDurable().equals(durable)) {
            this.durableKey = new DurableKey(this.durableKey.getDurableClass(), durable.getId());
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(D durable) {
        throw new UnsupportedOperationException("Attempted removal from a 'singular' vector");
    }

    @Override
    @AutolockRead
    public synchronized D head() {
        return this.getDurable();
    }

    @Override
    @AutolockRead
    public synchronized List<D> asBestEffortLazyList() {
        return Collections.singletonList(this.getDurable());
    }

    @Override
    @AutolockRead
    public synchronized Iterator<D> iterator() {
        return new SingleItemIterable(this.getDurable()).iterator();
    }
}

