/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.smallmind.nutsnbolts.util.SingleItemIterable;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.DurableVector;
import org.terracotta.annotations.AutolockRead;
import org.terracotta.annotations.AutolockWrite;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class ByReferenceSingularVector<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends DurableVector<I, D> {
    private D durable;

    public ByReferenceSingularVector(D durable, int timeToLiveSeconds) {
        super(null, 1, timeToLiveSeconds, false);
        this.durable = durable;
    }

    @Override
    @AutolockRead
    public DurableVector<I, D> copy() {
        return new ByReferenceSingularVector<I, D>(this.durable, this.getTimeToLiveSeconds());
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    @AutolockWrite
    public synchronized boolean add(D durable) {
        if (!this.durable.equals(durable)) {
            this.durable = durable;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(D durable) {
        throw new UnsupportedOperationException("Attempted removal from a 'singular' vector");
    }

    @Override
    @AutolockRead
    public synchronized D head() {
        return this.durable;
    }

    @Override
    @AutolockRead
    public synchronized List<D> asBestEffortLazyList() {
        return Collections.singletonList(this.durable);
    }

    @Override
    @AutolockRead
    public synchronized Iterator<D> iterator() {
        return new SingleItemIterable(this.durable).iterator();
    }
}

