/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis.extrinsic;

import java.io.Serializable;
import java.util.Comparator;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.AbstractCacheDao;
import org.smallmind.persistence.cache.CASSupportingPersistenceCache;
import org.smallmind.persistence.cache.CASValue;
import org.smallmind.persistence.cache.CacheDomain;
import org.smallmind.persistence.cache.DurableKey;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.VectorKey;
import org.smallmind.persistence.cache.praxis.ByKeySingularVector;
import org.smallmind.persistence.cache.praxis.extrinsic.ByKeyExtrinsicVector;

public class ByKeyExtrinsicCacheDao<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends AbstractCacheDao<I, D> {
    public ByKeyExtrinsicCacheDao(CacheDomain<I, D> cacheDomain) {
        super(cacheDomain);
    }

    @Override
    public D persist(Class<D> durableClass, D durable, UpdateMode mode) {
        if (durable != null) {
            DurableKey durableKey = new DurableKey(durableClass, durable.getId());
            switch (mode) {
                case SOFT: {
                    Durable cachedDurable = (Durable)this.getInstanceCache(durableClass).putIfAbsent(durableKey.getKey(), durable, 0);
                    return (D)(cachedDurable != null ? cachedDurable : durable);
                }
                case HARD: {
                    this.getInstanceCache(durableClass).set(durableKey.getKey(), durable, 0);
                    return durable;
                }
            }
            throw new UnknownSwitchCaseException(mode.name(), new Object[0]);
        }
        return null;
    }

    @Override
    public void updateInVector(VectorKey<D> vectorKey, D durable) {
        if (durable != null) {
            CASValue casValue;
            CASSupportingPersistenceCache persistenceCache = (CASSupportingPersistenceCache)this.getVectorCache(vectorKey.getElementClass());
            while ((casValue = persistenceCache.getViaCas(vectorKey.getKey())).getValue() != null) {
                DurableVector vectorCopy;
                DurableVector durableVector = vectorCopy = !persistenceCache.requiresCopyOnDistributedCASOperation() ? null : ((DurableVector)casValue.getValue()).copy();
                if (((DurableVector)casValue.getValue()).add(durable) && !persistenceCache.putViaCas(vectorKey.getKey(), vectorCopy, (DurableVector)casValue.getValue(), casValue.getVersion(), ((DurableVector)casValue.getValue()).getTimeToLiveSeconds())) continue;
            }
        }
    }

    @Override
    public void removeFromVector(VectorKey<D> vectorKey, D durable) {
        if (durable != null) {
            CASValue casValue;
            CASSupportingPersistenceCache persistenceCache = (CASSupportingPersistenceCache)this.getVectorCache(vectorKey.getElementClass());
            while ((casValue = persistenceCache.getViaCas(vectorKey.getKey())).getValue() != null) {
                DurableVector vectorCopy;
                if (((DurableVector)casValue.getValue()).isSingular()) {
                    this.deleteVector(vectorKey);
                    break;
                }
                DurableVector durableVector = vectorCopy = !persistenceCache.requiresCopyOnDistributedCASOperation() ? null : ((DurableVector)casValue.getValue()).copy();
                if (((DurableVector)casValue.getValue()).remove(durable) && !persistenceCache.putViaCas(vectorKey.getKey(), vectorCopy, (DurableVector)casValue.getValue(), casValue.getVersion(), ((DurableVector)casValue.getValue()).getTimeToLiveSeconds())) continue;
            }
        }
    }

    @Override
    public DurableVector<I, D> migrateVector(Class<D> managedClass, DurableVector<I, D> vector) {
        if (vector.isSingular()) {
            if (!(vector instanceof ByKeySingularVector)) {
                return new ByKeySingularVector(new DurableKey(managedClass, vector.head().getId()), vector.getTimeToLiveSeconds());
            }
            return vector;
        }
        if (!(vector instanceof ByKeyExtrinsicVector)) {
            return new ByKeyExtrinsicVector(managedClass, vector.asBestEffortPreFetchedList(), vector.getComparator(), vector.getMaxSize(), vector.getTimeToLiveSeconds(), vector.isOrdered());
        }
        return vector;
    }

    @Override
    public DurableVector<I, D> createSingularVector(VectorKey<D> vectorKey, D durable, int timeToLiveSeconds) {
        return new ByKeySingularVector(new DurableKey(vectorKey.getElementClass(), durable.getId()), timeToLiveSeconds);
    }

    @Override
    public DurableVector<I, D> createVector(VectorKey<D> vectorKey, Iterable<D> elementIter, Comparator<D> comparator, int maxSize, int timeToLiveSeconds, boolean ordered) {
        return new ByKeyExtrinsicVector(vectorKey.getElementClass(), elementIter, comparator, maxSize, timeToLiveSeconds, ordered);
    }
}

