/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis.intrinsic;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.DurableKey;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.praxis.AbstractDurableVector;
import org.smallmind.persistence.cache.praxis.ByKeyRoster;
import org.smallmind.persistence.cache.praxis.Roster;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRoster;
import org.terracotta.annotations.AutolockRead;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class ByKeyIntrinsicVector<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends AbstractDurableVector<I, D> {
    private ByKeyRoster<I, D> roster;

    public ByKeyIntrinsicVector(Class<D> durableClass, Iterable<D> durables, Comparator<D> comparator, int maxSize, int timeToLiveSeconds, boolean ordered) {
        super(comparator, maxSize, timeToLiveSeconds, ordered);
        IntrinsicRoster keyRoster = new IntrinsicRoster();
        int index = 0;
        for (Durable durable : durables) {
            keyRoster.add(new DurableKey(durableClass, durable.getId()));
            if (maxSize > 0 && ++index == maxSize) break;
        }
        this.roster = new ByKeyRoster(durableClass, keyRoster);
    }

    private ByKeyIntrinsicVector(ByKeyRoster<I, D> roster, Comparator<D> comparator, int maxSize, int timeToLiveSeconds, boolean ordered) {
        super(comparator, maxSize, timeToLiveSeconds, ordered);
        this.roster = roster;
    }

    @Override
    public Roster<D> getRoster() {
        return this.roster;
    }

    @Override
    @AutolockRead
    public DurableVector<I, D> copy() {
        return new ByKeyIntrinsicVector<I, D>(new ByKeyRoster<I, D>(this.roster.getDurableClass(), new IntrinsicRoster<DurableKey<I, D>>(this.roster.getInternalRoster())), this.getComparator(), this.getMaxSize(), this.getTimeToLiveSeconds(), this.isOrdered());
    }

    @Override
    @AutolockRead
    public synchronized List<D> asBestEffortLazyList() {
        return Collections.unmodifiableList(new LinkedList(this.roster));
    }

    @Override
    @AutolockRead
    public synchronized List<D> asBestEffortPreFetchedList() {
        return Collections.unmodifiableList(this.roster.prefetch());
    }

    @Override
    @AutolockRead
    public synchronized Iterator<D> iterator() {
        return Collections.unmodifiableList(new LinkedList(this.roster)).iterator();
    }
}

