/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis.intrinsic;

import java.io.Serializable;
import java.util.Comparator;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.AbstractCacheDao;
import org.smallmind.persistence.cache.CacheDomain;
import org.smallmind.persistence.cache.DurableKey;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.VectorKey;
import org.smallmind.persistence.cache.praxis.ByReferenceSingularVector;
import org.smallmind.persistence.cache.praxis.intrinsic.ByReferenceIntrinsicVector;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRoster;

public class ByReferenceIntrinsicCacheDao<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends AbstractCacheDao<I, D> {
    public ByReferenceIntrinsicCacheDao(CacheDomain<I, D> cacheDomain) {
        super(cacheDomain);
    }

    @Override
    public D persist(Class<D> durableClass, D durable, UpdateMode mode) {
        if (durable != null) {
            DurableKey durableKey = new DurableKey(durableClass, durable.getId());
            Durable cachedDurable = (Durable)this.getInstanceCache(durableClass).putIfAbsent(durableKey.getKey(), durable, 0);
            return (D)(cachedDurable != null ? cachedDurable : durable);
        }
        return null;
    }

    @Override
    public void updateInVector(VectorKey<D> vectorKey, D durable) {
        DurableVector vector;
        if (durable != null && (vector = this.getVectorCache(vectorKey.getElementClass()).get(vectorKey.getKey())) != null) {
            vector.add(durable);
        }
    }

    @Override
    public void removeFromVector(VectorKey<D> vectorKey, D durable) {
        DurableVector vector;
        if (durable != null && (vector = this.getVectorCache(vectorKey.getElementClass()).get(vectorKey.getKey())) != null) {
            if (vector.isSingular()) {
                this.deleteVector(vectorKey);
            } else {
                vector.remove(durable);
            }
        }
    }

    @Override
    public DurableVector<I, D> migrateVector(Class<D> managedClass, DurableVector<I, D> vector) {
        if (vector.isSingular()) {
            if (!(vector instanceof ByReferenceSingularVector)) {
                return new ByReferenceSingularVector(vector.head(), vector.getTimeToLiveSeconds());
            }
            return vector;
        }
        if (!(vector instanceof ByReferenceIntrinsicVector)) {
            return new ByReferenceIntrinsicVector(new IntrinsicRoster<D>(vector.asBestEffortPreFetchedList()), vector.getComparator(), vector.getMaxSize(), vector.getTimeToLiveSeconds(), vector.isOrdered());
        }
        return vector;
    }

    @Override
    public DurableVector<I, D> createSingularVector(VectorKey<D> vectorKey, D durable, int timeToLiveSeconds) {
        DurableKey durableKey = new DurableKey(vectorKey.getElementClass(), durable.getId());
        Durable inCacheDurable = (Durable)this.getInstanceCache(vectorKey.getElementClass()).putIfAbsent(durableKey.getKey(), durable, 0);
        if (inCacheDurable != null) {
            return new ByReferenceSingularVector(inCacheDurable, timeToLiveSeconds);
        }
        return new ByReferenceSingularVector(durable, timeToLiveSeconds);
    }

    @Override
    public DurableVector<I, D> createVector(VectorKey<D> vectorKey, Iterable<D> elementIter, Comparator<D> comparator, int maxSize, int timeToLiveSeconds, boolean ordered) {
        IntrinsicRoster<Durable> cacheConsistentElements = new IntrinsicRoster<Durable>();
        for (Durable element : elementIter) {
            if (element == null) continue;
            DurableKey durableKey = new DurableKey(vectorKey.getElementClass(), element.getId());
            Durable inCacheDurable = this.getInstanceCache(vectorKey.getElementClass()).putIfAbsent(durableKey.getKey(), element, timeToLiveSeconds);
            if (inCacheDurable != null) {
                cacheConsistentElements.add(inCacheDurable);
                continue;
            }
            cacheConsistentElements.add(element);
        }
        return new ByReferenceIntrinsicVector(cacheConsistentElements, comparator, maxSize, timeToLiveSeconds, ordered);
    }
}

