/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis.intrinsic;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.DurableVector;
import org.smallmind.persistence.cache.praxis.AbstractDurableVector;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRoster;
import org.terracotta.annotations.AutolockRead;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class ByReferenceIntrinsicVector<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends AbstractDurableVector<I, D> {
    private IntrinsicRoster<D> roster;

    public ByReferenceIntrinsicVector(IntrinsicRoster<D> roster, Comparator<D> comparator, int maxSize, int timeToLiveSeconds, boolean ordered) {
        super(comparator, maxSize, timeToLiveSeconds, ordered);
        this.roster = roster;
        if (maxSize > 0) {
            while (roster.size() > maxSize) {
                roster.removeLast();
            }
        }
    }

    @Override
    public IntrinsicRoster<D> getRoster() {
        return this.roster;
    }

    @Override
    @AutolockRead
    public DurableVector<I, D> copy() {
        return new ByReferenceIntrinsicVector<I, D>(new IntrinsicRoster<D>(this.roster), this.getComparator(), this.getMaxSize(), this.getTimeToLiveSeconds(), this.isOrdered());
    }

    @Override
    @AutolockRead
    public synchronized List<D> asBestEffortLazyList() {
        return Collections.unmodifiableList(this.getRoster());
    }

    @Override
    @AutolockRead
    public synchronized Iterator<D> iterator() {
        return Collections.unmodifiableList(this.getRoster()).iterator();
    }
}

