/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis.intrinsic;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.persistence.cache.praxis.Roster;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRosterIterator;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRosterNode;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRosterStructure;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class IntrinsicRoster<T>
implements Roster<T> {
    private final ReentrantReadWriteLock lock;
    private IntrinsicRosterStructure<T> structure;

    public IntrinsicRoster() {
        this(new ReentrantReadWriteLock(), new IntrinsicRosterStructure());
    }

    public IntrinsicRoster(Collection<? extends T> c) {
        this(new ReentrantReadWriteLock(), new IntrinsicRosterStructure());
        if (!c.isEmpty()) {
            IntrinsicRosterNode<T> added = null;
            for (T element : c) {
                if (added == null) {
                    added = new IntrinsicRosterNode<T>(element, null, null);
                    this.structure.setHead(added);
                    continue;
                }
                added = new IntrinsicRosterNode<T>(element, added, null);
                added.getPrev().setNext(added);
            }
            this.structure.setTail(added);
            this.structure.addSize(c.size());
        }
    }

    private IntrinsicRoster(ReentrantReadWriteLock lock, IntrinsicRosterStructure<T> structure) {
        this.lock = lock;
        this.structure = structure;
    }

    protected ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    protected IntrinsicRosterNode<T> getNextInView(IntrinsicRosterNode<T> current) {
        this.lock.readLock().lock();
        try {
            IntrinsicRosterNode<T> intrinsicRosterNode = this.structure.isTail(current) ? null : current.getNext();
            return intrinsicRosterNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected IntrinsicRosterNode<T> getPrevInView(IntrinsicRosterNode<T> current) {
        this.lock.readLock().lock();
        try {
            IntrinsicRosterNode<T> intrinsicRosterNode = this.structure.isHead(current) ? null : current.getPrev();
            return intrinsicRosterNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.structure.getSize();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.structure.getSize() == 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(Object obj) {
        this.lock.readLock().lock();
        try {
            if (this.structure.getSize() > 0) {
                IntrinsicRosterNode<T> current = this.structure.getHead();
                while (current != null) {
                    if (current.objEquals(obj)) {
                        return true;
                    }
                    current = this.getNextInView(current);
                }
            }
            return false;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray((U[])null);
    }

    @Override
    public <U> U[] toArray(U[] a) {
        this.lock.readLock().lock();
        try {
            U[] elements;
            Object[] objectArray = a != null && a.length >= this.structure.getSize() ? a : (elements = (Object[])Array.newInstance(a == null ? Object.class : a.getClass().getComponentType(), this.structure.getSize()));
            if (this.structure.getSize() > 0) {
                int index = 0;
                IntrinsicRosterNode<T> current = this.structure.getHead();
                while (current != null) {
                    elements[index++] = current.getObj();
                    current = this.getNextInView(current);
                }
            }
            if (elements.length > this.structure.getSize()) {
                elements[this.structure.getSize()] = null;
            }
            U[] UArray = elements;
            return UArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private IntrinsicRosterNode<T> getNode(int index) {
        if (index < 0 || index >= this.structure.getSize()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (index <= this.structure.getSize() / 2) {
            IntrinsicRosterNode<T> current = this.structure.getHead();
            int count = 0;
            while (count < index) {
                current = current.getNext();
                ++count;
            }
            return current;
        }
        IntrinsicRosterNode<T> current = this.structure.getTail();
        int count = this.structure.getSize() - 1;
        while (count > index) {
            current = current.getPrev();
            --count;
        }
        return current;
    }

    @Override
    public T getFirst() {
        this.lock.readLock().lock();
        try {
            if (this.structure.getSize() == 0) {
                throw new NoSuchElementException();
            }
            T t = this.structure.getHead().getObj();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T getLast() {
        this.lock.readLock().lock();
        try {
            if (this.structure.getSize() == 0) {
                throw new NoSuchElementException();
            }
            T t = this.structure.getTail().getObj();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T get(int index) {
        this.lock.readLock().lock();
        try {
            T t = this.getNode(index).getObj();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T set(int index, T element) {
        this.lock.readLock().lock();
        try {
            IntrinsicRosterNode<T> current = this.getNode(index);
            T value = current.getObj();
            current.setObj(element);
            T t = value;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void add(IntrinsicRosterNode<T> next, T element) {
        IntrinsicRosterNode<T> prev = next.getPrev();
        IntrinsicRosterNode<T> added = new IntrinsicRosterNode<T>(element, prev, next);
        next.setPrev(added);
        if (prev != null) {
            prev.setNext(added);
        }
        if (this.structure.isHead(next)) {
            this.structure.setHead(added);
        }
        this.structure.incSize();
    }

    @Override
    public void addFirst(T element) {
        this.lock.writeLock().lock();
        try {
            if (this.structure.getSize() == 0) {
                this.structure.ouroboros(element);
            } else {
                this.add(this.structure.getHead(), element);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void addLast(T element) {
        this.lock.writeLock().lock();
        try {
            if (this.structure.getSize() == 0) {
                this.structure.ouroboros(element);
            } else {
                IntrinsicRosterNode<T> end = this.structure.getTail().getNext();
                IntrinsicRosterNode<T> added = new IntrinsicRosterNode<T>(element, this.structure.getTail(), end);
                if (end != null) {
                    end.setPrev(added);
                }
                this.structure.getTail().setNext(added);
                this.structure.setTail(added);
                this.structure.incSize();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean add(T element) {
        this.addLast(element);
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.lock.writeLock().lock();
        try {
            if (index == this.structure.getSize()) {
                this.addLast(element);
            } else {
                this.add(this.getNode(index), element);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void removeNode(IntrinsicRosterNode<T> current) {
        IntrinsicRosterNode<T> prev = current.getPrev();
        IntrinsicRosterNode<T> next = current.getNext();
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        this.structure.decSize();
        this.structure.evaporate(prev, current, next);
    }

    @Override
    public T removeFirst() {
        this.lock.writeLock().lock();
        try {
            if (this.structure.getSize() == 0) {
                throw new NoSuchElementException();
            }
            T element = this.structure.getHead().getObj();
            this.removeNode(this.structure.getHead());
            T t = element;
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public T removeLast() {
        this.lock.writeLock().lock();
        try {
            if (this.structure.getSize() == 0) {
                throw new NoSuchElementException();
            }
            T element = this.structure.getTail().getObj();
            this.removeNode(this.structure.getTail());
            T t = element;
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            IntrinsicRosterNode<T> current = this.structure.getHead();
            while (current != null) {
                if (current.objEquals(o)) {
                    this.removeNode(current);
                    return true;
                }
                current = this.getNextInView(current);
            }
            return false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public T remove(int index) {
        this.lock.writeLock().lock();
        try {
            IntrinsicRosterNode<T> current = this.getNode(index);
            this.removeNode(current);
            T t = current.getObj();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        HashSet checkSet = new HashSet(c);
        this.lock.readLock().lock();
        try {
            IntrinsicRosterNode<T> current = this.structure.getHead();
            while (current != null) {
                checkSet.remove(current.getObj());
                if (checkSet.isEmpty()) {
                    return true;
                }
                current = this.getNextInView(current);
            }
            return false;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (!c.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                for (T element : c) {
                    this.addLast(element);
                }
                return true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (!c.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                IntrinsicRosterNode<T> next = this.getNode(index);
                for (T element : c) {
                    this.add(next, element);
                }
                return true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        HashSet checkSet = new HashSet(c);
        boolean changed = false;
        this.lock.writeLock().lock();
        try {
            IntrinsicRosterNode<T> current = this.structure.getHead();
            while (current != null) {
                if (checkSet.contains(current.getObj())) {
                    this.removeNode(current);
                    changed = true;
                }
                current = this.getNextInView(current);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        HashSet checkSet = new HashSet(c);
        boolean changed = false;
        this.lock.writeLock().lock();
        try {
            IntrinsicRosterNode<T> current = this.structure.getHead();
            while (current != null) {
                if (!checkSet.contains(current.getObj())) {
                    this.removeNode(current);
                    changed = true;
                }
                current = this.getNextInView(current);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.structure.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int index = 0;
            IntrinsicRosterNode<T> current = this.structure.getHead();
            while (current != null) {
                if (current.objEquals(o)) {
                    int n = index;
                    return n;
                }
                ++index;
                current = this.getNextInView(current);
            }
            return -1;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int index = this.structure.getSize() - 1;
            IntrinsicRosterNode<T> current = this.structure.getTail();
            while (current != null) {
                if (current.objEquals(o)) {
                    int n = index;
                    return n;
                }
                --index;
                current = this.getPrevInView(current);
            }
            return -1;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        this.lock.readLock().lock();
        try {
            IntrinsicRosterIterator<T> intrinsicRosterIterator = new IntrinsicRosterIterator<T>(this, null, this.structure.getSize() == 0 ? null : this.structure.getHead(), 0);
            return intrinsicRosterIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.lock.readLock().lock();
        try {
            if (index > this.structure.getSize()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            if (index == this.structure.getSize()) {
                IntrinsicRosterIterator<T> intrinsicRosterIterator = new IntrinsicRosterIterator<T>(this, this.structure.getSize() == 0 ? null : this.structure.getTail(), null, index);
                return intrinsicRosterIterator;
            }
            IntrinsicRosterNode<T> current = this.getNode(index);
            IntrinsicRosterIterator<T> intrinsicRosterIterator = new IntrinsicRosterIterator<T>(this, this.getPrevInView(current), current, index);
            return intrinsicRosterIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(fromIndex) + " > " + toIndex);
        }
        this.lock.readLock().lock();
        try {
            IntrinsicRoster<T> intrinsicRoster = new IntrinsicRoster<T>(this.lock, new IntrinsicRosterStructure<T>(this.structure, this.getNode(fromIndex), fromIndex == toIndex ? this.getNode(fromIndex).getNext() : this.getNode(toIndex - 1), toIndex - fromIndex));
            return intrinsicRoster;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

