/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis.intrinsic;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRoster;
import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRosterNode;

public class IntrinsicRosterIterator<T>
implements ListIterator<T> {
    private IntrinsicRoster<T> concurrentList;
    private IntrinsicRosterNode<T> next;
    private IntrinsicRosterNode<T> prev;
    private IntrinsicRosterNode<T> current;
    private int index;

    public IntrinsicRosterIterator(IntrinsicRoster<T> concurrentList, IntrinsicRosterNode<T> prev, IntrinsicRosterNode<T> next, int index) {
        this.concurrentList = concurrentList;
        this.next = next;
        this.prev = prev;
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.next.getObj();
            return t;
        }
        finally {
            this.current = this.next;
            this.prev = this.next;
            this.next = this.concurrentList.getNextInView(this.next);
            ++this.index;
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.prev != null;
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.prev.getObj();
            return t;
        }
        finally {
            this.current = this.prev;
            this.next = this.prev;
            this.prev = this.concurrentList.getPrevInView(this.prev);
            --this.index;
        }
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void set(T obj) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.current.setObj(obj);
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.concurrentList.getLock().writeLock().lock();
        try {
            this.concurrentList.removeNode(this.current);
        }
        finally {
            this.concurrentList.getLock().writeLock().unlock();
        }
        this.current = null;
    }

    @Override
    public void add(T t) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.concurrentList.getLock().writeLock().lock();
        try {
            this.concurrentList.add(this.current, t);
        }
        finally {
            this.concurrentList.getLock().writeLock().unlock();
        }
        this.current = null;
    }
}

