/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.cache.praxis.intrinsic;

import org.smallmind.persistence.cache.praxis.intrinsic.IntrinsicRosterNode;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public class IntrinsicRosterStructure<T> {
    private IntrinsicRosterStructure<T> parent;
    private IntrinsicRosterNode<T> head;
    private IntrinsicRosterNode<T> tail;
    int size;

    public IntrinsicRosterStructure() {
        this.size = 0;
    }

    public IntrinsicRosterStructure(IntrinsicRosterStructure<T> parent, IntrinsicRosterNode<T> head, IntrinsicRosterNode<T> tail, int size) {
        this.parent = parent;
        this.head = head;
        this.tail = tail;
        this.size = size;
    }

    public IntrinsicRosterNode<T> getHead() {
        return this.head;
    }

    public void setHead(IntrinsicRosterNode<T> head) {
        if (this.parent != null && this.parent.isHead(this.head)) {
            this.parent.setHead(head);
        }
        this.head = head;
    }

    public boolean isHead(IntrinsicRosterNode<T> node) {
        return this.head != null && node == this.head;
    }

    public IntrinsicRosterNode<T> getTail() {
        return this.tail;
    }

    public void setTail(IntrinsicRosterNode<T> tail) {
        if (this.parent != null && this.parent.isTail(this.tail)) {
            this.parent.setTail(tail);
        }
        this.tail = tail;
    }

    public boolean isTail(IntrinsicRosterNode<T> node) {
        return this.tail != null && node == this.tail;
    }

    public void evaporate(IntrinsicRosterNode<T> prev, IntrinsicRosterNode<T> current, IntrinsicRosterNode<T> next) {
        if (this.parent != null) {
            this.evaporate(prev, current, next);
        }
        if (this.size == 0) {
            this.head = prev;
            this.tail = next;
        } else if (this.head == current) {
            this.head = next;
        } else if (this.tail == current) {
            this.tail = prev;
        }
    }

    public void ouroboros(T element) {
        IntrinsicRosterNode<T> added = new IntrinsicRosterNode<T>(element, this.head, this.tail);
        if (this.head != null) {
            this.head.setNext(added);
        }
        if (this.tail != null) {
            this.tail.setPrev(added);
        }
        if (this.parent != null) {
            this.parent.reconstitute(added, this.head, this.tail);
        }
        this.tail = added;
        this.head = this.tail;
        this.size = 1;
    }

    public void reconstitute(IntrinsicRosterNode<T> added, IntrinsicRosterNode<T> head, IntrinsicRosterNode<T> tail) {
        if (this.parent != null) {
            this.parent.reconstitute(added, head, tail);
        }
        if (head == null) {
            this.head = added;
        }
        if (tail == null) {
            this.tail = added;
        }
        ++this.size;
    }

    public void clear() {
        if (this.size > 0) {
            this.head = this.head.getPrev();
            this.tail = this.tail.getNext();
            if (this.head != null) {
                this.head.setNext(this.tail);
            }
            if (this.tail != null) {
                this.tail.setPrev(this.head);
            }
            this.subtractSize(this.getSize());
        }
    }

    public int getSize() {
        return this.size;
    }

    public void addSize(int delta) {
        if (this.parent != null) {
            this.parent.addSize(delta);
        }
        this.size += delta;
    }

    public void subtractSize(int delta) {
        if (this.parent != null) {
            this.parent.subtractSize(delta);
        }
        this.size -= delta;
    }

    public void incSize() {
        if (this.parent != null) {
            this.parent.incSize();
        }
        ++this.size;
    }

    public void decSize() {
        if (this.parent != null) {
            this.parent.decSize();
        }
        --this.size;
    }
}

