/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.database.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.LinkedList;
import org.smallmind.persistence.database.mongodb.MongoDatabase;
import org.smallmind.persistence.database.mongodb.MongoServer;
import org.springframework.beans.factory.FactoryBean;

public class MongoClientFactoryBean
implements FactoryBean<MongoClient> {
    private MongoServer[] servers;
    private MongoDatabase[] databases;
    private MongoClientOptions clientOptions;
    private WriteConcern writeConcern = WriteConcern.JOURNALED;

    public void setServers(MongoServer[] servers) {
        this.servers = servers;
    }

    public void setDatabases(MongoDatabase[] databases) {
        this.databases = databases;
    }

    public void setClientOptions(MongoClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return MongoClient.class;
    }

    public MongoClient getObject() {
        LinkedList<ServerAddress> serverAddresses = new LinkedList<ServerAddress>();
        LinkedList<MongoCredential> credentialList = new LinkedList<MongoCredential>();
        Object[] objectArray = this.databases;
        int n = this.databases.length;
        int n2 = 0;
        while (n2 < n) {
            MongoDatabase mongoDatabase = objectArray[n2];
            if (mongoDatabase.getUser() != null && !mongoDatabase.getUser().isEmpty()) {
                credentialList.add(MongoCredential.createCredential((String)mongoDatabase.getUser(), (String)mongoDatabase.getDatabase(), (char[])mongoDatabase.getPassword().toCharArray()));
            }
            ++n2;
        }
        objectArray = this.servers;
        n = this.servers.length;
        n2 = 0;
        while (n2 < n) {
            Object mongoServer = objectArray[n2];
            serverAddresses.add(new ServerAddress(((MongoServer)mongoServer).getHost(), ((MongoServer)mongoServer).getPort()));
            ++n2;
        }
        MongoClient mongoClient = serverAddresses.size() == 1 ? new MongoClient((ServerAddress)serverAddresses.getFirst(), credentialList, this.clientOptions) : new MongoClient(serverAddresses, credentialList, this.clientOptions);
        mongoClient.setWriteConcern(this.writeConcern);
        return mongoClient;
    }
}

