/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.database.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.beans.factory.FactoryBean;

public class MongoClientOptionsFactoryBean
implements FactoryBean<MongoClientOptions> {
    private final MongoClientOptions.Builder optionsBuilder;
    private boolean socketKeepAlive;
    private int connectionsPerHost;
    private int threadsAllowedToBlockForConnectionMultiplier;
    private int connectTimeout;
    private int maxWaitTime;
    private int socketTimeout;

    public MongoClientOptionsFactoryBean() {
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClient.getDefaultCodecRegistry()});
        this.optionsBuilder = MongoClientOptions.builder().codecRegistry(codecRegistry);
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.optionsBuilder.connectionsPerHost(connectionsPerHost);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.optionsBuilder.connectTimeout(connectTimeout);
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.optionsBuilder.maxWaitTime(maxWaitTime);
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.optionsBuilder.socketKeepAlive(socketKeepAlive);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.optionsBuilder.socketTimeout(socketTimeout);
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.optionsBuilder.threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier);
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return MongoClientOptions.class;
    }

    public MongoClientOptions getObject() throws Exception {
        return this.optionsBuilder.build();
    }
}

