/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.database.mongodb;

import java.util.LinkedList;
import org.smallmind.nutsnbolts.util.Spread;
import org.smallmind.nutsnbolts.util.SpreadParserException;
import org.smallmind.persistence.database.mongodb.MongoServer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class MongoServerFactoryBean
implements FactoryBean<MongoServer[]>,
InitializingBean {
    private MongoServer[] serverArray;
    private String serverPattern;
    private String serverSpread;

    public void setServerPattern(String serverPattern) {
        this.serverPattern = serverPattern;
    }

    public void setServerSpread(String serverSpread) {
        this.serverSpread = serverSpread;
    }

    public void afterPropertiesSet() throws SpreadParserException {
        if (this.serverPattern != null && this.serverPattern.length() > 0) {
            LinkedList<MongoServer> serverList = new LinkedList<MongoServer>();
            int colonPos = this.serverPattern.indexOf(58);
            int poundPos = this.serverPattern.indexOf(35);
            if (poundPos < 0) {
                if (colonPos >= 0) {
                    serverList.add(new MongoServer(this.serverPattern.substring(0, colonPos), Integer.parseInt(this.serverPattern.substring(colonPos + 1))));
                } else {
                    serverList.add(new MongoServer(this.serverPattern, 27017));
                }
            } else {
                String[] stringArray = Spread.calculate((String)this.serverSpread);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String serverDesignator = stringArray[n2];
                    if (colonPos >= 0) {
                        serverList.add(new MongoServer(String.valueOf(this.serverPattern.substring(0, poundPos)) + serverDesignator + this.serverPattern.substring(poundPos + 1, colonPos), Integer.parseInt(this.serverPattern.substring(colonPos + 1))));
                    } else {
                        serverList.add(new MongoServer(String.valueOf(this.serverPattern.substring(0, poundPos)) + serverDesignator + this.serverPattern.substring(poundPos + 1), 27017));
                    }
                    ++n2;
                }
            }
            this.serverArray = new MongoServer[serverList.size()];
            serverList.toArray(this.serverArray);
        }
    }

    public MongoServer[] getObject() {
        return this.serverArray;
    }

    public Class<?> getObjectType() {
        return MongoServer[].class;
    }

    public boolean isSingleton() {
        return true;
    }
}

