/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.smallmind.persistence.database.Sequence;
import org.smallmind.persistence.database.SequenceManager;
import org.smallmind.persistence.database.mysql.SimulatedSequenceDisasterException;
import org.smallmind.scribe.pen.LoggerManager;

public class SimulatedSequence
extends Sequence {
    private final ConcurrentHashMap<String, SequenceData> DATA_MAP = new ConcurrentHashMap();
    private final DataSource dataSource;
    private final String tableName;
    private final int incrementBy;

    public SimulatedSequence(DataSource dataSource, String tableName, int incrementBy) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.incrementBy = incrementBy;
    }

    @Override
    public void register() {
        SequenceManager.register(this);
    }

    @Override
    public long nextLong(String name) {
        return this.getSequenceData(name).nextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SequenceData getSequenceData(String name) {
        SequenceData sequenceData = this.DATA_MAP.get(name);
        if (sequenceData == null) {
            ConcurrentHashMap<String, SequenceData> concurrentHashMap = this.DATA_MAP;
            synchronized (concurrentHashMap) {
                sequenceData = this.DATA_MAP.get(name);
                if (sequenceData == null) {
                    sequenceData = new SequenceData(name);
                    this.DATA_MAP.put(name, sequenceData);
                }
            }
        }
        return sequenceData;
    }

    private class SequenceData {
        private final AtomicLong atomicBoundary;
        private final AtomicLong atomicOffset = new AtomicLong(0L);
        private final String name;
        private final String insertSql;
        private final String updateSql;

        public SequenceData(String name) {
            this.name = name;
            this.insertSql = "INSERT IGNORE INTO " + SimulatedSequence.this.tableName + " (name, next_val) VALUES('" + name + "', 0)";
            this.updateSql = "UPDATE " + SimulatedSequence.this.tableName + " SET next_val=LAST_INSERT_ID(next_val + " + SimulatedSequence.this.incrementBy + ") where name='" + name + "'";
            this.insertName();
            this.atomicBoundary = new AtomicLong(this.getLastInsertId());
        }

        public long nextLong() {
            long nextValue = 0L;
            do {
                long currentOffset;
                if (SimulatedSequence.this.incrementBy == 1) {
                    nextValue = this.getLastInsertId();
                    continue;
                }
                do {
                    if ((currentOffset = this.atomicOffset.incrementAndGet()) < (long)SimulatedSequence.this.incrementBy) {
                        nextValue = this.atomicBoundary.get() + currentOffset;
                        continue;
                    }
                    if (currentOffset != (long)SimulatedSequence.this.incrementBy) continue;
                    try {
                        nextValue = this.getLastInsertId();
                        this.atomicBoundary.set(nextValue);
                        this.atomicOffset.set(0L);
                    }
                    catch (SimulatedSequenceDisasterException simulatedSequenceDisasterException) {
                        LoggerManager.getLogger(SimulatedSequence.class).error((Throwable)((Object)simulatedSequenceDisasterException));
                        currentOffset = SimulatedSequence.this.incrementBy + 1;
                        this.atomicOffset.set(SimulatedSequence.this.incrementBy - 1);
                    }
                } while (currentOffset > (long)SimulatedSequence.this.incrementBy);
            } while (nextValue == 0L);
            return nextValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void insertName() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try {
                    Connection connection = SimulatedSequence.this.dataSource.getConnection();
                    try {
                        try (Statement statement = connection.createStatement(1003, 1007);){
                            connection.setAutoCommit(true);
                            statement.executeUpdate(this.insertSql);
                        }
                        if (connection == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (connection == null) throw throwable;
                        connection.close();
                        throw throwable;
                    }
                    connection.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sqlException) {
                throw new SimulatedSequenceDisasterException(sqlException, "Unable to create sequence(%s)", this.name);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long getLastInsertId() {
            try {
                var1_1 = null;
                var2_6 = null;
                try {
                    connection = SimulatedSequence.access$2(SimulatedSequence.this).getConnection();
                    try {
                        block25: {
                            statement = connection.createStatement(1003, 1007);
                            try {
                                connection.setAutoCommit(true);
                                statement.executeUpdate(this.updateSql, 1);
                                var5_11 = null;
                                var6_13 = null;
                                try {
                                    block24: {
                                        resultSet = statement.getGeneratedKeys();
                                        try {
                                            if (resultSet.next()) {
                                                v0 = resultSet.getLong(1);
                                                if (resultSet == null) break block24;
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        catch (Throwable var5_12) {
                                            if (resultSet == null) throw var5_12;
                                            resultSet.close();
                                            throw var5_12;
                                        }
                                        resultSet.close();
                                    }
                                    if (statement == null) break block25;
                                }
                                catch (Throwable var6_14) {
                                    if (var5_11 == null) {
                                        var5_11 = var6_14;
                                        throw var5_11;
                                    }
                                    if (var5_11 == var6_14) throw var5_11;
                                    var5_11.addSuppressed(var6_14);
                                    throw var5_11;
                                }
                            }
                            catch (Throwable var1_2) {
                                if (statement == null) throw var1_2;
                                statement.close();
                                throw var1_2;
                            }
                            statement.close();
                        }
                        if (connection == null) return v0;
                    }
                    catch (Throwable var2_7) {
                        if (var1_1 == null) {
                            var1_1 = var2_7;
                        } else if (var1_1 != var2_7) {
                            var1_1.addSuppressed(var2_7);
                        }
                        if (connection == null) throw var1_1;
                        connection.close();
                        throw var1_1;
                    }
                    connection.close();
                    return v0;
lbl-1000:
                    // 1 sources

                    {
                        throw new SimulatedSequenceDisasterException("No sequence(%s) has been generated", new Object[]{this.name});
                    }
                }
                catch (Throwable var2_8) {
                    if (var1_1 == null) {
                        var1_1 = var2_8;
                        throw var1_1;
                    }
                    if (var1_1 == var2_8) throw var1_1;
                    var1_1.addSuppressed(var2_8);
                    throw var1_1;
                }
            }
            catch (SimulatedSequenceDisasterException simulatedSequenceDisasterException) {
                throw simulatedSequenceDisasterException;
            }
            catch (SQLException sqlException) {
                throw new SimulatedSequenceDisasterException(sqlException, "Unable to update sequence(%s)", new Object[]{this.name});
            }
            catch (Throwable throwable) {
                throw new SimulatedSequenceDisasterException(throwable, "Unknown exception encountered in sequence(%s) update", new Object[]{this.name});
            }
        }
    }
}

