/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.smallmind.nutsnbolts.reflection.type.GenericUtility;
import org.smallmind.nutsnbolts.reflection.type.TypeInference;
import org.smallmind.persistence.AbstractWideVectorAwareManagedDao;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.WideDurableDao;
import org.smallmind.persistence.cache.WideVectoredDao;

public abstract class NoSqlDao<W extends Serializable & Comparable<W>, I extends Serializable & Comparable<I>, D extends Durable<I>>
extends AbstractWideVectorAwareManagedDao<W, I, D>
implements WideDurableDao<W, I, D> {
    private final TypeInference parentIdTypeInference = new TypeInference();
    private boolean cacheEnabled;

    public NoSqlDao(String metricSource, WideVectoredDao<W, I, D> wideVectoredDao, boolean cacheEnabled) {
        super(metricSource, wideVectoredDao);
        this.cacheEnabled = cacheEnabled;
        List typeArguments = GenericUtility.getTypeArguments(NoSqlDao.class, this.getClass());
        if (typeArguments.size() == 3 && typeArguments.get(0) != null) {
            this.parentIdTypeInference.addPossibility((Class)typeArguments.get(0));
        }
    }

    public Class<I> getParentIdClass() {
        return this.parentIdTypeInference.getInference();
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public void remove(String context, Class<? extends Durable<W>> parentClass, W parentId) {
        this.remove(context, parentClass, parentId, this.getManagedClass());
    }

    @Override
    public List<D> get(String context, Class<? extends Durable<W>> parentClass, W parentId) {
        return this.get(context, parentClass, parentId, this.getManagedClass());
    }

    @Override
    public List<D> persist(String context, Class<? extends Durable<W>> parentClass, W parentId, D ... durables) {
        return this.persist(context, parentClass, (Serializable)parentId, this.getManagedClass(), (Durable[])durables);
    }

    @Override
    public List<D> persist(String context, Class<? extends Durable<W>> parentClass, W parentId, List<D> durables) {
        return this.persist(context, parentClass, parentId, this.getManagedClass(), durables);
    }

    @Override
    public List<D> persist(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass, D ... durables) {
        return this.persist(context, parentClass, parentId, durableClass, Arrays.asList(durables));
    }

    @Override
    public void delete(String context, Class<? extends Durable<W>> parentClass, W parentId, D ... durables) {
        this.delete(context, parentClass, (Serializable)parentId, this.getManagedClass(), (Durable[])durables);
    }

    @Override
    public void delete(String context, Class<? extends Durable<W>> parentClass, W parentId, List<D> durables) {
        this.delete(context, parentClass, parentId, this.getManagedClass(), durables);
    }

    @Override
    public void delete(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass, D ... durables) {
        this.delete(context, parentClass, parentId, durableClass, Arrays.asList(durables));
    }
}

