/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.hector;

import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import org.smallmind.persistence.nosql.hector.HectorTranslator;

public class CharacterTranslator
implements HectorTranslator<Character, String> {
    @Override
    public String getHectorType() {
        return "UTF8Type";
    }

    @Override
    public Serializer<String> getSerializer() {
        return StringSerializer.get();
    }

    @Override
    public String toHectorValue(Character value) {
        return new String(new char[]{value.charValue()});
    }

    @Override
    public Character toEntityValue(Class<?> fieldType, int index, Composite columnName) {
        return Character.valueOf(((String)columnName.get(index, (Serializer)StringSerializer.get())).charAt(0));
    }

    @Override
    public Character toEntityValue(Class<?> fieldType, Composite columnName, ColumnFamilyResult<Composite, Composite> hectorResult) {
        return Character.valueOf(hectorResult.getString((Object)columnName).charAt(0));
    }
}

