/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.hector;

import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import org.smallmind.persistence.PersistenceException;
import org.smallmind.persistence.nosql.hector.HectorTranslator;

public class EnumTranslator
implements HectorTranslator<Enum<?>, String> {
    @Override
    public String getHectorType() {
        return "UTF8Type";
    }

    @Override
    public Serializer<String> getSerializer() {
        return StringSerializer.get();
    }

    @Override
    public String toHectorValue(Enum<?> value) {
        return value.name();
    }

    @Override
    public Enum<?> toEntityValue(Class<?> fieldType, int index, Composite columnName) {
        return this.fromName(fieldType, (String)columnName.get(index, (Serializer)StringSerializer.get()));
    }

    @Override
    public Enum<?> toEntityValue(Class<?> fieldType, Composite columnName, ColumnFamilyResult<Composite, Composite> hectorResult) {
        return this.fromName(fieldType, hectorResult.getString((Object)columnName));
    }

    private Enum<?> fromName(Class<?> fieldType, String enumName) {
        ?[] objArray = fieldType.getEnumConstants();
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object enumConstant = objArray[n2];
            if (((Enum)enumConstant).name().equals(enumName)) {
                return (Enum)enumConstant;
            }
            ++n2;
        }
        throw new PersistenceException("Unable to locate matching enum constant(%s) for field of type(%s)", enumName, fieldType.getName());
    }
}

