/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.hector;

import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import org.smallmind.persistence.nosql.hector.HectorTranslator;

public class FloatTranslator
implements HectorTranslator<Float, Double> {
    @Override
    public String getHectorType() {
        return "DoubleType";
    }

    @Override
    public Serializer<Double> getSerializer() {
        return DoubleSerializer.get();
    }

    @Override
    public Double toHectorValue(Float value) {
        return value.doubleValue();
    }

    @Override
    public Float toEntityValue(Class<?> fieldType, int index, Composite columnName) {
        return Float.valueOf(((Double)columnName.get(index, (Serializer)DoubleSerializer.get())).floatValue());
    }

    @Override
    public Float toEntityValue(Class<?> fieldType, Composite columnName, ColumnFamilyResult<Composite, Composite> hectorResult) {
        return Float.valueOf(hectorResult.getDouble((Object)columnName).floatValue());
    }
}

