/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.hector;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.prettyprint.cassandra.serializers.CompositeSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import me.prettyprint.cassandra.service.template.ColumnFamilyUpdater;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import org.smallmind.nutsnbolts.reflection.FieldUtility;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.NaturalKey;
import org.smallmind.persistence.PersistenceException;
import org.smallmind.persistence.cache.WideVectoredDao;
import org.smallmind.persistence.nosql.NoSqlDao;
import org.smallmind.persistence.nosql.hector.HectorDurable;
import org.smallmind.persistence.nosql.hector.HectorTranslator;
import org.smallmind.persistence.nosql.hector.HectorType;

public abstract class HectorDao<W extends Serializable & Comparable<W>, I extends Serializable & Comparable<I>, D extends HectorDurable<I, D>>
extends NoSqlDao<W, I, D> {
    private ColumnFamilyTemplate<Composite, Composite> hectorTemplate;

    public HectorDao(String metricSource, Keyspace keyspace, WideVectoredDao<W, I, D> wideVectoredDao, boolean cacheEnabled) {
        super(metricSource, wideVectoredDao, cacheEnabled);
        this.hectorTemplate = new ThriftColumnFamilyTemplate(keyspace, this.getManagedClass().getSimpleName(), (Serializer)CompositeSerializer.get(), (Serializer)CompositeSerializer.get());
        this.hectorTemplate.setCount(Integer.MAX_VALUE);
    }

    public abstract I createId();

    @Override
    public void remove(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass) {
        WideVectoredDao wideVectoredDao;
        this.hectorTemplate.deleteRow((Object)new Composite(new Object[]{context, parentClass.getSimpleName(), HectorType.getTranslator(this.getParentIdClass(), "parentId").toHectorValue(parentId)}));
        if (this.isCacheEnabled() && (wideVectoredDao = this.getWideVectoredDao()) != null) {
            wideVectoredDao.delete(context, parentClass, parentId, durableClass);
        }
    }

    @Override
    public List<D> get(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass) {
        List durables;
        WideVectoredDao wideVectoredDao;
        if (this.isCacheEnabled() && (wideVectoredDao = this.getWideVectoredDao()) != null && (durables = wideVectoredDao.get(context, parentClass, parentId, durableClass)) != null) {
            return durables;
        }
        ColumnFamilyResult hectorResult = this.hectorTemplate.queryColumns((Object)new Composite(new Object[]{context, parentClass.getSimpleName(), HectorType.getTranslator(this.getParentIdClass(), "parentId").toHectorValue(parentId)}));
        if (hectorResult.hasResults()) {
            HashMap<NaturalKey<D>, HectorDurable> naturalMap = new HashMap<NaturalKey<D>, HectorDurable>();
            for (Composite columnName : hectorResult.getColumnNames()) {
                Field naturalKeyField;
                Field[] naturalKeyFields = NaturalKey.getNaturalKeyFields(durableClass);
                Object[] naturalKeyValues = new Object[naturalKeyFields.length];
                String nonKeyFieldName = (String)columnName.get(naturalKeyFields.length, (Serializer)StringSerializer.get());
                Field nonKeyField = FieldUtility.getField(durableClass, (String)nonKeyFieldName);
                if (nonKeyField == null) {
                    throw new PersistenceException("Unknown field(%s) in return values", nonKeyFieldName);
                }
                int naturalKeyIndex = 0;
                Field[] fieldArray = naturalKeyFields;
                int n = naturalKeyFields.length;
                int n2 = 0;
                while (n2 < n) {
                    naturalKeyField = fieldArray[n2];
                    naturalKeyValues[naturalKeyIndex] = HectorType.getTranslator(naturalKeyField.getType(), naturalKeyField.getName()).toEntityValue(naturalKeyField.getType(), naturalKeyIndex++, columnName);
                    ++n2;
                }
                NaturalKey<D> naturalKey = new NaturalKey<D>(durableClass, naturalKeyValues);
                HectorDurable durable = (HectorDurable)naturalMap.get(naturalKey);
                if (durable == null) {
                    try {
                        durable = (HectorDurable)durableClass.newInstance();
                        naturalMap.put(naturalKey, durable);
                        naturalKeyIndex = 0;
                        fieldArray = naturalKeyFields;
                        n = naturalKeyFields.length;
                        n2 = 0;
                        while (n2 < n) {
                            naturalKeyField = fieldArray[n2];
                            naturalKeyField.set(durable, naturalKeyValues[naturalKeyIndex++]);
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        throw new PersistenceException(exception);
                    }
                }
                try {
                    if (nonKeyFieldName.equals("id")) {
                        nonKeyField.set(durable, HectorType.getTranslator(this.getIdClass(), "id").toEntityValue(this.getIdClass(), columnName, (ColumnFamilyResult<Composite, Composite>)hectorResult));
                        continue;
                    }
                    Class<?> nonKeyType = nonKeyField.getType();
                    nonKeyField.set(durable, HectorType.getTranslator(nonKeyType, nonKeyFieldName).toEntityValue(nonKeyType, columnName, (ColumnFamilyResult<Composite, Composite>)hectorResult));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new PersistenceException(illegalAccessException);
                }
            }
            durables = new LinkedList(naturalMap.values());
            if (this.isCacheEnabled() && (wideVectoredDao = this.getWideVectoredDao()) != null) {
                wideVectoredDao.persist(context, parentClass, parentId, durableClass, durables);
            }
            return durables;
        }
        return Collections.emptyList();
    }

    @Override
    public List<D> persist(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass, List<D> durables) {
        if (durables != null && !durables.isEmpty()) {
            List cachedInstance;
            WideVectoredDao wideVectoredDao;
            ColumnFamilyUpdater updater = this.hectorTemplate.createUpdater((Object)new Composite(new Object[]{context, parentClass.getSimpleName(), HectorType.getTranslator(this.getParentIdClass(), "parentId").toHectorValue(parentId)}));
            try {
                Field[] fieldArray = NaturalKey.getNonKeyFields(durableClass);
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field nonKeyField = fieldArray[n2];
                    for (HectorDurable durable : durables) {
                        Object id = durable.getId();
                        if (id == null) {
                            id = this.createId();
                            durable.setId(id);
                        }
                        Composite nonKeyComposite = new Composite();
                        Field[] fieldArray2 = NaturalKey.getNaturalKeyFields(durableClass);
                        int n3 = fieldArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Field naturalKeyField = fieldArray2[n4];
                            nonKeyComposite.add(HectorType.getTranslator(naturalKeyField.getType(), naturalKeyField.getName()).toHectorValue(naturalKeyField.get(durable)));
                            ++n4;
                        }
                        nonKeyComposite.add((Object)nonKeyField.getName());
                        if (nonKeyField.getName().equals("id")) {
                            HectorTranslator idTranslator = HectorType.getTranslator(this.getIdClass(), "id");
                            updater.setValue((Object)nonKeyComposite, idTranslator.toHectorValue(id), idTranslator.getSerializer());
                            continue;
                        }
                        Object nonKeyValue = nonKeyField.get(durable);
                        if (nonKeyValue == null) {
                            updater.deleteColumn((Object)nonKeyComposite);
                            continue;
                        }
                        HectorTranslator nonKeyTranslator = HectorType.getTranslator(nonKeyField.getType(), nonKeyField.getName());
                        updater.setValue((Object)nonKeyComposite, nonKeyTranslator.toHectorValue(nonKeyValue), nonKeyTranslator.getSerializer());
                    }
                    ++n2;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PersistenceException(illegalAccessException);
            }
            if (this.isCacheEnabled() && (wideVectoredDao = this.getWideVectoredDao()) != null && (cachedInstance = wideVectoredDao.get(context, parentClass, parentId, durableClass)) != null) {
                for (HectorDurable durable : durables) {
                    int cachedIndex = cachedInstance.indexOf(durable);
                    if (cachedIndex >= 0) {
                        cachedInstance.set(cachedIndex, durable);
                        continue;
                    }
                    cachedInstance.add(durable);
                }
                wideVectoredDao.persist(context, parentClass, parentId, durableClass, cachedInstance);
            }
            this.hectorTemplate.update(updater);
        }
        return durables;
    }

    @Override
    public void delete(String context, Class<? extends Durable<W>> parentClass, W parentId, Class<D> durableClass, List<D> durables) {
        if (durables != null && !durables.isEmpty()) {
            List cachedInstance;
            WideVectoredDao wideVectoredDao;
            ColumnFamilyUpdater updater = this.hectorTemplate.createUpdater((Object)new Composite(new Object[]{context, parentClass.getSimpleName(), HectorType.getTranslator(this.getParentIdClass(), "parentId").toHectorValue(parentId)}));
            try {
                Field[] fieldArray = NaturalKey.getNonKeyFields(durableClass);
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field nonKeyField = fieldArray[n2];
                    for (HectorDurable durable : durables) {
                        Composite nonKeyComposite = new Composite();
                        Field[] fieldArray2 = NaturalKey.getNaturalKeyFields(durableClass);
                        int n3 = fieldArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Field naturalKeyField = fieldArray2[n4];
                            nonKeyComposite.add(HectorType.getTranslator(naturalKeyField.getType(), naturalKeyField.getName()).toHectorValue(naturalKeyField.get(durable)));
                            ++n4;
                        }
                        nonKeyComposite.add((Object)nonKeyField.getName());
                        updater.deleteColumn((Object)nonKeyComposite);
                    }
                    ++n2;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PersistenceException(illegalAccessException);
            }
            if (this.isCacheEnabled() && (wideVectoredDao = this.getWideVectoredDao()) != null && (cachedInstance = wideVectoredDao.get(context, parentClass, parentId, durableClass)) != null) {
                for (HectorDurable durable : durables) {
                    cachedInstance.remove(durable);
                }
                wideVectoredDao.persist(context, parentClass, parentId, durableClass, cachedInstance);
            }
            this.hectorTemplate.update(updater);
        }
    }
}

