/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.hector;

import java.util.Date;
import org.smallmind.persistence.PersistenceException;
import org.smallmind.persistence.nosql.hector.BooleanTranslator;
import org.smallmind.persistence.nosql.hector.ByteTranslator;
import org.smallmind.persistence.nosql.hector.CharacterTranslator;
import org.smallmind.persistence.nosql.hector.DateTranslator;
import org.smallmind.persistence.nosql.hector.DoubleTranslator;
import org.smallmind.persistence.nosql.hector.EnumTranslator;
import org.smallmind.persistence.nosql.hector.FloatTranslator;
import org.smallmind.persistence.nosql.hector.HectorTranslator;
import org.smallmind.persistence.nosql.hector.IntegerTranslator;
import org.smallmind.persistence.nosql.hector.LongTranslator;
import org.smallmind.persistence.nosql.hector.ShortTranslator;
import org.smallmind.persistence.nosql.hector.StringTranslator;

public enum HectorType {
    BYTE(new ByteTranslator()),
    SHORT(new ShortTranslator()),
    INTEGER(new IntegerTranslator()),
    LONG(new LongTranslator()),
    FLOAT(new FloatTranslator()),
    DOUBLE(new DoubleTranslator()),
    BOOLEAN(new BooleanTranslator()),
    CHARACTER(new CharacterTranslator()),
    STRING(new StringTranslator()),
    DATE(new DateTranslator()),
    ENUM(new EnumTranslator());

    private HectorTranslator hectorTranslator;

    private HectorType(HectorTranslator hectorTranslator) {
        this.hectorTranslator = hectorTranslator;
    }

    public static HectorTranslator getTranslator(Class<?> fieldType, String fieldName) {
        if (Date.class.isAssignableFrom(fieldType)) {
            return DATE.getHectorTranslator();
        }
        if (fieldType.isEnum()) {
            return ENUM.getHectorTranslator();
        }
        if (CharSequence.class.isAssignableFrom(fieldType)) {
            return STRING.getHectorTranslator();
        }
        if (Long.TYPE.equals(fieldType) || Long.class.equals(fieldType)) {
            return LONG.getHectorTranslator();
        }
        if (Boolean.TYPE.equals(fieldType) || Boolean.class.equals(fieldType)) {
            return BOOLEAN.getHectorTranslator();
        }
        if (Integer.TYPE.equals(fieldType) || Integer.class.equals(fieldType)) {
            return INTEGER.getHectorTranslator();
        }
        if (Double.TYPE.equals(fieldType) || Double.class.equals(fieldType)) {
            return DOUBLE.getHectorTranslator();
        }
        if (Float.TYPE.equals(fieldType) || Float.class.equals(fieldType)) {
            return FLOAT.getHectorTranslator();
        }
        if (Character.TYPE.equals(fieldType) || Character.class.equals(fieldType)) {
            return CHARACTER.getHectorTranslator();
        }
        if (Short.TYPE.equals(fieldType) || Short.class.equals(fieldType)) {
            return SHORT.getHectorTranslator();
        }
        if (Byte.TYPE.equals(fieldType) || Byte.class.equals(fieldType)) {
            return BYTE.getHectorTranslator();
        }
        throw new PersistenceException("Unknown field(%s) type(%s)", fieldName, fieldType.getName());
    }

    public HectorTranslator getHectorTranslator() {
        return this.hectorTranslator;
    }
}

