/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.spring.hector;

import java.util.HashMap;
import java.util.HashSet;
import org.smallmind.persistence.NaturalKeys;
import org.smallmind.persistence.nosql.hector.HectorDao;
import org.smallmind.persistence.orm.SessionSource;
import org.smallmind.persistence.spring.ManagedDaoSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class HectorFileSeekingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final HashMap<String, HashSet<Class>> HECTOR_DATA_SOURCE_MAP = new HashMap();

    public static HashSet<Class> getHectorTypes(String keyspaceName) {
        return HECTOR_DATA_SOURCE_MAP.get(keyspaceName);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String sessionSourceKey = null;
        String[] stringArray = configurableListableBeanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Class beanClass = configurableListableBeanFactory.getType(beanName);
            if (beanClass != null && HectorDao.class.isAssignableFrom(beanClass)) {
                Class persistentClass;
                HashSet<Class<Object>> hectorTypes;
                SessionSource sessionSource = beanClass.getAnnotation(SessionSource.class);
                if (sessionSource != null) {
                    sessionSourceKey = sessionSource.value();
                }
                if ((hectorTypes = HECTOR_DATA_SOURCE_MAP.get(sessionSourceKey)) == null) {
                    hectorTypes = new HashSet();
                    HECTOR_DATA_SOURCE_MAP.put(sessionSourceKey, hectorTypes);
                }
                if ((persistentClass = ManagedDaoSupport.findDurableClass(beanClass)) == null) {
                    throw new FatalBeanException("No inference of the Durable class for type(" + beanClass.getName() + ") was possible");
                }
                if (persistentClass.getAnnotation(NaturalKeys.class) == null) {
                    throw new FatalBeanException("Missing annotation(" + NaturalKeys.class.getSimpleName() + ") on durable type(" + persistentClass.getSimpleName() + ")");
                }
                hectorTypes.add(persistentClass);
            }
            ++n2;
        }
    }
}

