/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.spring.hector;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import me.prettyprint.cassandra.model.BasicKeyspaceDefinition;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.NaturalKey;
import org.smallmind.persistence.nosql.hector.HectorType;
import org.smallmind.persistence.nosql.spring.hector.HectorFileSeekingBeanFactoryPostProcessor;

public class HectorSchemaVerifier {
    public static void verify(Cluster cluster, Keyspace keyspace, String replicationStrategyClass, int replicationFactor) {
        KeyspaceDefinition keyspaceDefinition;
        LinkedList<Class> hectorTypes = new LinkedList<Class>(HectorFileSeekingBeanFactoryPostProcessor.getHectorTypes(keyspace.getKeyspaceName()));
        while ((keyspaceDefinition = cluster.describeKeyspace(keyspace.getKeyspaceName())) == null) {
            BasicKeyspaceDefinition avatarKeyspace = new BasicKeyspaceDefinition();
            avatarKeyspace.setName(keyspace.getKeyspaceName());
            avatarKeyspace.setDurableWrites(true);
            avatarKeyspace.setStrategyClass(replicationStrategyClass);
            avatarKeyspace.setReplicationFactor(replicationFactor);
            cluster.addKeyspace((KeyspaceDefinition)avatarKeyspace, true);
        }
        block1: for (ColumnFamilyDefinition columnFamilyDefinition : keyspaceDefinition.getCfDefs()) {
            Iterator hectorTypeIter = hectorTypes.iterator();
            while (hectorTypeIter.hasNext()) {
                if (!((Class)hectorTypeIter.next()).getSimpleName().equals(columnFamilyDefinition.getName())) continue;
                hectorTypeIter.remove();
                continue block1;
            }
        }
        for (Class hectorType : hectorTypes) {
            ColumnFamilyDefinition attributeKeyFamilyDefinition = HFactory.createColumnFamilyDefinition((String)keyspace.getKeyspaceName(), (String)hectorType.getSimpleName(), (ComparatorType)ComparatorType.COMPOSITETYPE);
            attributeKeyFamilyDefinition.setColumnType(ColumnType.STANDARD);
            attributeKeyFamilyDefinition.setKeyValidationClass(String.valueOf(ComparatorType.COMPOSITETYPE.getClassName()) + "(UTF8Type, UTF8Type, LongType)");
            attributeKeyFamilyDefinition.setDefaultValidationClass(ComparatorType.BYTESTYPE.getClassName());
            attributeKeyFamilyDefinition.setComparatorTypeAlias(HectorSchemaVerifier.composeTypeAlias(hectorType));
            cluster.addColumnFamily(attributeKeyFamilyDefinition, true);
        }
    }

    private static String composeTypeAlias(Class<? extends Durable> durableType) {
        StringBuilder aliasBuilder = new StringBuilder("(");
        Field[] fieldArray = NaturalKey.getNaturalKeyFields(durableType);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field naturalKeyField = fieldArray[n2];
            aliasBuilder.append(HectorType.getTranslator(naturalKeyField.getType(), naturalKeyField.getName()).getHectorType()).append(',');
            ++n2;
        }
        return aliasBuilder.append("UTF8Type)").toString();
    }
}

