/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.nosql.spring.hector;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import me.prettyprint.cassandra.connection.RoundRobinBalancingPolicy;
import me.prettyprint.cassandra.model.ConfigurableConsistencyLevel;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.HConsistencyLevel;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.factory.HFactory;
import org.smallmind.nutsnbolts.util.Spread;
import org.smallmind.nutsnbolts.util.SpreadParserException;
import org.smallmind.persistence.nosql.spring.hector.HectorSchemaVerifier;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class KeyspaceFactoryBean
implements FactoryBean<Keyspace>,
InitializingBean {
    private static final HashMap<String, ThriftCluster> CLUSTER_MAP = new HashMap();
    private static final HashMap<ConsistencyPair, ConfigurableConsistencyLevel> CONSISTENCY_LEVEL_MAP = new HashMap();
    private Keyspace keyspace;
    private HConsistencyLevel defaultReadConsistencyLevel = HConsistencyLevel.QUORUM;
    private HConsistencyLevel defaultWriteConsistencyLevel = HConsistencyLevel.QUORUM;
    private LoadBalancingPolicy loadBalancingPolicy = new RoundRobinBalancingPolicy();
    private String serverPattern;
    private String serverSpread;
    private String clusterName;
    private String keyspaceName;
    private String replicationStrategyClass;
    private boolean verify = false;
    private long waitTimeWhenExhausted = 5000L;
    private int replicationFactor;
    private int maxActive = 50;

    public void setServerPattern(String serverPattern) {
        this.serverPattern = serverPattern;
    }

    public void setServerSpread(String serverSpread) {
        this.serverSpread = serverSpread;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public void setDefaultReadConsistencyLevel(HConsistencyLevel defaultReadConsistencyLevel) {
        this.defaultReadConsistencyLevel = defaultReadConsistencyLevel;
    }

    public void setDefaultWriteConsistencyLevel(HConsistencyLevel defaultWriteConsistencyLevel) {
        this.defaultWriteConsistencyLevel = defaultWriteConsistencyLevel;
    }

    public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }

    public void setReplicationStrategyClass(String replicationStrategyClass) {
        this.replicationStrategyClass = replicationStrategyClass;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setWaitTimeWhenExhausted(long waitTimeWhenExhausted) {
        this.waitTimeWhenExhausted = waitTimeWhenExhausted;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public synchronized void afterPropertiesSet() throws SpreadParserException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.serverPattern != null && this.serverPattern.length() > 0) {
            ConfigurableConsistencyLevel consistencyLevelPolicy;
            ConsistencyPair consistencyPair = new ConsistencyPair(this.defaultReadConsistencyLevel, this.defaultWriteConsistencyLevel);
            StringBuilder serverBuilder = new StringBuilder();
            int poundPos = this.serverPattern.indexOf(35);
            if (poundPos < 0) {
                serverBuilder.append(this.serverPattern);
            } else {
                boolean first = true;
                String[] stringArray = Spread.calculate((String)this.serverSpread);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String serverDesignator = stringArray[n2];
                    if (!first) {
                        serverBuilder.append(',');
                    }
                    serverBuilder.append(this.serverPattern.substring(0, poundPos)).append(serverDesignator).append(this.serverPattern.substring(poundPos + 1));
                    first = false;
                    ++n2;
                }
            }
            ThriftCluster thriftCluster = CLUSTER_MAP.get(serverBuilder.toString());
            if (thriftCluster == null) {
                CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator(serverBuilder.toString());
                cassandraHostConfigurator.setLoadBalancingPolicy(this.loadBalancingPolicy);
                cassandraHostConfigurator.setMaxActive(this.maxActive);
                cassandraHostConfigurator.setMaxWaitTimeWhenExhausted(this.waitTimeWhenExhausted);
                thriftCluster = new ThriftCluster(this.clusterName, cassandraHostConfigurator);
                CLUSTER_MAP.put(serverBuilder.toString(), thriftCluster);
            }
            if ((consistencyLevelPolicy = CONSISTENCY_LEVEL_MAP.get(consistencyPair)) == null) {
                consistencyLevelPolicy = new ConfigurableConsistencyLevel();
                CONSISTENCY_LEVEL_MAP.put(consistencyPair, consistencyLevelPolicy);
                consistencyLevelPolicy.setDefaultReadConsistencyLevel(this.defaultReadConsistencyLevel);
                consistencyLevelPolicy.setDefaultWriteConsistencyLevel(this.defaultWriteConsistencyLevel);
            }
            this.keyspace = HFactory.createKeyspace((String)this.keyspaceName, (Cluster)thriftCluster, (ConsistencyLevelPolicy)consistencyLevelPolicy);
            if (this.verify) {
                HectorSchemaVerifier.verify((Cluster)thriftCluster, this.keyspace, this.replicationStrategyClass, this.replicationFactor);
            }
        }
    }

    public Class<?> getObjectType() {
        return Keyspace.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Keyspace getObject() {
        return this.keyspace;
    }

    private class ConsistencyPair {
        private HConsistencyLevel read;
        private HConsistencyLevel write;

        public ConsistencyPair(HConsistencyLevel read, HConsistencyLevel write) {
            this.read = read;
            this.write = write;
        }

        public HConsistencyLevel getRead() {
            return this.read;
        }

        public HConsistencyLevel getWrite() {
            return this.write;
        }

        public int hashCode() {
            return this.read.hashCode() ^ this.write.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ConsistencyPair && ((ConsistencyPair)obj).getRead().equals((Object)this.read) && ((ConsistencyPair)obj).getWrite().equals((Object)this.write);
        }
    }
}

