/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm;

import java.io.Serializable;
import org.smallmind.persistence.AbstractVectorAwareManagedDao;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.orm.OrmDaoManager;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.RelationalDao;

public abstract class ORMDao<I extends Serializable & Comparable<I>, D extends Durable<I>, F, N>
extends AbstractVectorAwareManagedDao<I, D>
implements RelationalDao<I, D, F, N> {
    private ProxySession<F, N> proxySession;

    public ORMDao(ProxySession<F, N> proxySession, VectoredDao<I, D> vectoredDao) {
        super(proxySession.getDataSourceType(), vectoredDao);
        this.proxySession = proxySession;
    }

    public void register() {
        OrmDaoManager.register(this.getManagedClass(), this);
    }

    @Override
    public String getSessionSourceKey() {
        return this.proxySession.getSessionSourceKey();
    }

    @Override
    public ProxySession<F, N> getSession() {
        return this.proxySession;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.proxySession.isCacheEnabled();
    }

    public abstract D acquire(Class<D> var1, I var2);

    @Override
    public D get(I id) {
        return (D)((Durable)this.get(this.getManagedClass(), id));
    }

    @Override
    public D persist(D durable) {
        return this.persist(this.getManagedClass(), durable);
    }

    @Override
    public void delete(D durable) {
        this.delete(this.getManagedClass(), durable);
    }
}

