/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm;

import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.SessionManager;

public abstract class ProxySession<F, N> {
    private String dataSourceType;
    private String sessionSourceKey;
    private boolean boundaryEnforced;
    private final ThreadLocal<Boolean> boundaryEnforcedThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return ProxySession.this.boundaryEnforced;
        }
    };
    private boolean cacheEnabled;
    private final ThreadLocal<Boolean> cacheEnabledThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return ProxySession.this.cacheEnabled;
        }
    };

    public ProxySession(String dataSourceType, String sessionSourceKey, boolean boundaryEnforced, boolean cacheEnabled) {
        this.dataSourceType = dataSourceType;
        this.sessionSourceKey = sessionSourceKey;
        this.boundaryEnforced = boundaryEnforced;
        this.cacheEnabled = cacheEnabled;
    }

    public void register() {
        SessionManager.register(this.sessionSourceKey, this);
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public String getSessionSourceKey() {
        return this.sessionSourceKey;
    }

    public boolean isBoundaryEnforced() {
        return this.boundaryEnforcedThreadLocal.get();
    }

    public void overrideBoundaryEnforced(boolean boundaryEnforced) {
        this.boundaryEnforcedThreadLocal.set(boundaryEnforced);
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabledThreadLocal.get();
    }

    public void overrideCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabledThreadLocal.set(cacheEnabled);
    }

    public abstract F getNativeSessionFactory();

    public abstract N getNativeSession();

    public abstract ProxyTransaction beginTransaction();

    public abstract ProxyTransaction currentTransaction();

    public abstract void flush();

    public abstract void clear();

    public abstract boolean isClosed();

    public abstract void close();
}

