/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm;

import java.util.Collections;
import java.util.LinkedList;
import java.util.UUID;
import org.smallmind.persistence.orm.ProcessPriorityComparator;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.TransactionEndState;
import org.smallmind.persistence.orm.TransactionPostProcess;
import org.smallmind.persistence.orm.TransactionPostProcessException;

public abstract class ProxyTransaction<S extends ProxySession> {
    private static final ProcessPriorityComparator PROCESS_PRIORITY_COMPARATOR = new ProcessPriorityComparator();
    private S proxySession;
    private LinkedList<TransactionPostProcess> postProcessList;
    private String uuidAsString;
    private boolean rollbackOnly = false;

    public ProxyTransaction(S proxySession) {
        this.proxySession = proxySession;
        this.uuidAsString = UUID.randomUUID().toString();
    }

    public abstract void flush();

    public abstract void commit();

    public abstract void rollback();

    public abstract boolean isCompleted();

    public String getUniqueId() {
        return this.uuidAsString;
    }

    public S getSession() {
        return this.proxySession;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    private LinkedList<TransactionPostProcess> getPostProcessList() {
        return this.postProcessList == null ? (this.postProcessList = new LinkedList()) : this.postProcessList;
    }

    public void addPostProcess(TransactionPostProcess postProcess) {
        this.getPostProcessList().add(postProcess);
    }

    protected void applyPostProcesses(TransactionEndState endState) throws TransactionPostProcessException {
        TransactionPostProcessException postProcessException = null;
        Collections.sort(this.getPostProcessList(), PROCESS_PRIORITY_COMPARATOR);
        for (TransactionPostProcess postProcess : this.getPostProcessList()) {
            if (!postProcess.getEndState().equals((Object)TransactionEndState.ANY) && !postProcess.getEndState().equals((Object)endState)) continue;
            try {
                postProcess.process();
            }
            catch (Exception exception) {
                if (postProcessException == null) {
                    postProcessException = new TransactionPostProcessException(exception);
                    continue;
                }
                postProcessException.addSubsequentCause(exception);
            }
        }
        if (postProcessException != null) {
            throw postProcessException;
        }
    }

    public int hashCode() {
        return this.uuidAsString.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ProxyTransaction && this.uuidAsString.equals(((ProxyTransaction)obj).getUniqueId());
    }
}

