/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm;

import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.nutsnbolts.lang.PerApplicationContext;
import org.smallmind.nutsnbolts.lang.PerApplicationDataManager;
import org.smallmind.persistence.orm.ORMInitializationException;
import org.smallmind.persistence.orm.ProxySession;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SessionManager
implements PerApplicationDataManager,
ApplicationContextAware {
    public static void register(String sessionSourceKey, ProxySession proxySession) {
        ConcurrentHashMap<String, ProxySession> sessionMap = (ConcurrentHashMap<String, ProxySession>)PerApplicationContext.getPerApplicationData(SessionManager.class, ConcurrentHashMap.class);
        if (sessionMap == null) {
            sessionMap = new ConcurrentHashMap<String, ProxySession>();
            PerApplicationContext.setPerApplicationData(SessionManager.class, sessionMap);
        }
        sessionMap.put(sessionSourceKey, proxySession);
    }

    public static ProxySession getSession() {
        return SessionManager.getSession(null);
    }

    public static ProxySession getSession(String sessionSourceKey) {
        ProxySession proxySession = (ProxySession)((ConcurrentHashMap)PerApplicationContext.getPerApplicationData(SessionManager.class, ConcurrentHashMap.class)).get(sessionSourceKey);
        if (proxySession == null) {
            throw new ORMInitializationException("No ProxySession was mapped to the data source value(%s)", sessionSourceKey);
        }
        return proxySession;
    }

    public static void closeSession() {
        SessionManager.closeSession(null);
    }

    public static void closeSession(String sessionSourceKey) {
        SessionManager.getSession(sessionSourceKey).close();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        PerApplicationContext.setPerApplicationData(SessionManager.class, new ConcurrentHashMap());
    }
}

