/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.aop;

import java.util.HashSet;
import org.smallmind.persistence.orm.ProxySession;

public class BoundarySet<T>
extends HashSet<T> {
    private String[] sessionSourceKeys;
    private boolean implicit;

    public BoundarySet(String[] sessionSourceKeys, boolean implicit) {
        this.sessionSourceKeys = sessionSourceKeys;
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit && this.sessionSourceKeys.length == 0;
    }

    public boolean allows(ProxySession proxySession) {
        return this.allows(proxySession.getSessionSourceKey());
    }

    public boolean allows(String sessionSourceKey) {
        if (this.sessionSourceKeys.length == 0) {
            return this.isImplicit() || sessionSourceKey == null;
        }
        if (this.isImplicit()) {
            throw new IllegalArgumentException("Boundary annotation (@NonTransaction or @Transactional) is marked as implicit, but explicitly lists data sources");
        }
        if (sessionSourceKey != null) {
            String[] stringArray = this.sessionSourceKeys;
            int n = this.sessionSourceKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String boundarySource = stringArray[n2];
                if (sessionSourceKey.equals(boundarySource)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

