/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.aop;

import java.util.LinkedList;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.aop.BoundarySet;
import org.smallmind.persistence.orm.aop.NonTransactional;
import org.smallmind.persistence.orm.aop.SessionBoundaryError;
import org.smallmind.persistence.orm.aop.SessionError;
import org.smallmind.persistence.orm.aop.TransactionalState;
import org.smallmind.persistence.orm.aop.UnexpectedSessionError;

public class NonTransactionalState {
    private static final ThreadLocal<LinkedList<BoundarySet<ProxySession>>> SESSION_SET_STACK_LOCAL = new ThreadLocal();

    public static boolean isInSession() {
        return NonTransactionalState.isInSession(null);
    }

    public static boolean isInSession(String sessionSourceKey) {
        return NonTransactionalState.currentSession(sessionSourceKey) != null;
    }

    public static ProxySession currentSession(String sessionSourceKey) {
        ProxyTransaction currentTransaction = TransactionalState.currentTransaction(sessionSourceKey);
        if (currentTransaction != null) {
            return currentTransaction.getSession();
        }
        LinkedList<BoundarySet<ProxySession>> sessionSetStack = SESSION_SET_STACK_LOCAL.get();
        if (sessionSetStack != null) {
            for (BoundarySet boundarySet : sessionSetStack) {
                for (ProxySession proxySession : boundarySet) {
                    if (!(sessionSourceKey == null ? proxySession.getSessionSourceKey() == null : sessionSourceKey.equals(proxySession.getSessionSourceKey()))) continue;
                    return proxySession;
                }
            }
        }
        return null;
    }

    protected static boolean containsSession(ProxySession proxySession) {
        LinkedList<BoundarySet<ProxySession>> sessionSetStack = SESSION_SET_STACK_LOCAL.get();
        if (sessionSetStack != null) {
            for (BoundarySet boundarySet : sessionSetStack) {
                if (!boundarySet.contains(proxySession)) continue;
                return true;
            }
        }
        return false;
    }

    public static BoundarySet<ProxySession> obtainBoundary(ProxySession proxySession) {
        LinkedList<BoundarySet<ProxySession>> sessionSetStack = SESSION_SET_STACK_LOCAL.get();
        if (sessionSetStack != null) {
            for (BoundarySet boundarySet : sessionSetStack) {
                if (!boundarySet.allows(proxySession)) continue;
                return boundarySet;
            }
        }
        return null;
    }

    protected static void startBoundary(NonTransactional nonTransactional) {
        LinkedList sessionSetStack = SESSION_SET_STACK_LOCAL.get();
        if (sessionSetStack == null) {
            sessionSetStack = new LinkedList();
            SESSION_SET_STACK_LOCAL.set(sessionSetStack);
        }
        sessionSetStack.addLast(new BoundarySet(nonTransactional.dataSources(), nonTransactional.implicit()));
    }

    protected static void endBoundary(Throwable throwable) throws SessionError {
        block10: {
            if (throwable == null || !(throwable instanceof SessionError) || SESSION_SET_STACK_LOCAL.get() != null && SESSION_SET_STACK_LOCAL.get().size() != ((SessionError)((Object)throwable)).getClosure()) {
                UnexpectedSessionError unexpectedSessionError = null;
                LinkedList<BoundarySet<ProxySession>> sessionSetStack = SESSION_SET_STACK_LOCAL.get();
                if (sessionSetStack == null || sessionSetStack.isEmpty()) {
                    throw new SessionBoundaryError(0, throwable, "No session boundary has been enforced", new Object[0]);
                }
                try {
                    for (ProxySession proxySession : sessionSetStack.removeLast()) {
                        try {
                            proxySession.close();
                        }
                        catch (Throwable unexpectedThrowable) {
                            if (unexpectedSessionError != null) continue;
                            unexpectedSessionError = new UnexpectedSessionError(sessionSetStack.size(), unexpectedThrowable);
                        }
                    }
                    if (unexpectedSessionError != null) {
                        throw unexpectedSessionError;
                    }
                    break block10;
                }
                finally {
                    if (sessionSetStack.isEmpty()) {
                        SESSION_SET_STACK_LOCAL.remove();
                    }
                }
            }
            SESSION_SET_STACK_LOCAL.remove();
        }
    }
}

