/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.aop;

import java.util.LinkedList;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.aop.IncompleteTransactionError;
import org.smallmind.persistence.orm.aop.NonTransactionalState;
import org.smallmind.persistence.orm.aop.RollbackAwareBoundarySet;
import org.smallmind.persistence.orm.aop.StolenTransactionError;
import org.smallmind.persistence.orm.aop.TransactionBoundaryError;
import org.smallmind.persistence.orm.aop.TransactionError;
import org.smallmind.persistence.orm.aop.Transactional;

public class TransactionalState {
    private static final ThreadLocal<LinkedList<RollbackAwareBoundarySet<ProxyTransaction>>> TRANSACTION_SET_STACK_LOCAL = new ThreadLocal();

    public static boolean isInTransaction() {
        return TransactionalState.isInTransaction(null);
    }

    public static boolean isInTransaction(String sessionSourceKey) {
        return TransactionalState.currentTransaction(sessionSourceKey) != null;
    }

    public static ProxyTransaction currentTransaction(String sessionSourceKey) {
        LinkedList<RollbackAwareBoundarySet<ProxyTransaction>> transactionSetStack = TRANSACTION_SET_STACK_LOCAL.get();
        if (transactionSetStack != null) {
            for (RollbackAwareBoundarySet rollbackAwareBoundarySet : transactionSetStack) {
                for (ProxyTransaction proxyTransaction : rollbackAwareBoundarySet) {
                    if (!(sessionSourceKey == null ? ((ProxySession)proxyTransaction.getSession()).getSessionSourceKey() == null : sessionSourceKey.equals(((ProxySession)proxyTransaction.getSession()).getSessionSourceKey()))) continue;
                    return proxyTransaction;
                }
            }
        }
        return null;
    }

    public static boolean withinBoundary(ProxySession proxySession) {
        return TransactionalState.withinBoundary(proxySession.getSessionSourceKey());
    }

    public static boolean withinBoundary(String sessionSourceKey) {
        LinkedList<RollbackAwareBoundarySet<ProxyTransaction>> transactionSetStack = TRANSACTION_SET_STACK_LOCAL.get();
        if (transactionSetStack != null) {
            for (RollbackAwareBoundarySet rollbackAwareBoundarySet : transactionSetStack) {
                if (!rollbackAwareBoundarySet.allows(sessionSourceKey)) continue;
                return true;
            }
        }
        return false;
    }

    public static RollbackAwareBoundarySet<ProxyTransaction> obtainBoundary(ProxySession proxySession) {
        LinkedList<RollbackAwareBoundarySet<ProxyTransaction>> transactionSetStack = TRANSACTION_SET_STACK_LOCAL.get();
        if (transactionSetStack != null) {
            for (RollbackAwareBoundarySet rollbackAwareBoundarySet : transactionSetStack) {
                if (!rollbackAwareBoundarySet.allows(proxySession)) continue;
                if (NonTransactionalState.containsSession(proxySession)) {
                    throw new StolenTransactionError("Attempt to steal the session - a non-transactional boundary is already enforced", new Object[0]);
                }
                return rollbackAwareBoundarySet;
            }
        }
        return null;
    }

    protected static void startBoundary(Transactional transactional) {
        LinkedList<RollbackAwareBoundarySet<ProxyTransaction<Object>>> transactionSetStack = TRANSACTION_SET_STACK_LOCAL.get();
        if (transactionSetStack == null) {
            transactionSetStack = new LinkedList();
            TRANSACTION_SET_STACK_LOCAL.set(transactionSetStack);
        }
        transactionSetStack.addLast(new RollbackAwareBoundarySet(transactional.dataSources(), transactional.implicit(), transactional.rollbackOnly()));
    }

    protected static void commitBoundary() throws TransactionError {
        TransactionalState.commitBoundary(null);
    }

    protected static void commitBoundary(Throwable throwable) throws TransactionError {
        block11: {
            if (throwable == null || !(throwable instanceof TransactionError) || TRANSACTION_SET_STACK_LOCAL.get() != null && TRANSACTION_SET_STACK_LOCAL.get().size() != ((TransactionError)((Object)throwable)).getClosure()) {
                IncompleteTransactionError incompleteTransactionError = null;
                LinkedList<RollbackAwareBoundarySet<ProxyTransaction>> transactionSetStack = TRANSACTION_SET_STACK_LOCAL.get();
                if (transactionSetStack == null || transactionSetStack.isEmpty()) {
                    throw new TransactionBoundaryError(0, "No transaction boundary has been enforced", new Object[0]);
                }
                try {
                    RollbackAwareBoundarySet<ProxyTransaction> transactionSet = transactionSetStack.removeLast();
                    for (ProxyTransaction proxyTransaction : transactionSet) {
                        try {
                            if (transactionSet.isRollbackOnly() || proxyTransaction.isRollbackOnly()) {
                                proxyTransaction.rollback();
                                continue;
                            }
                            proxyTransaction.commit();
                        }
                        catch (Throwable unexpectedThrowable) {
                            if (incompleteTransactionError != null) continue;
                            incompleteTransactionError = new IncompleteTransactionError(transactionSetStack.size(), unexpectedThrowable);
                        }
                    }
                    if (incompleteTransactionError != null) {
                        throw incompleteTransactionError;
                    }
                    break block11;
                }
                finally {
                    if (transactionSetStack.isEmpty()) {
                        TRANSACTION_SET_STACK_LOCAL.remove();
                    }
                }
            }
            TRANSACTION_SET_STACK_LOCAL.remove();
        }
    }

    protected static void rollbackBoundary(Throwable throwable) throws TransactionError {
        block10: {
            if (throwable == null || !(throwable instanceof TransactionError) || TRANSACTION_SET_STACK_LOCAL.get() != null && TRANSACTION_SET_STACK_LOCAL.get().size() != ((TransactionError)((Object)throwable)).getClosure()) {
                IncompleteTransactionError incompleteTransactionError = null;
                LinkedList<RollbackAwareBoundarySet<ProxyTransaction>> transactionSetStack = TRANSACTION_SET_STACK_LOCAL.get();
                if (transactionSetStack == null || transactionSetStack.isEmpty()) {
                    throw new TransactionBoundaryError(0, throwable, "No transaction boundary has been enforced", new Object[0]);
                }
                try {
                    for (ProxyTransaction proxyTransaction : transactionSetStack.removeLast()) {
                        try {
                            proxyTransaction.rollback();
                        }
                        catch (Throwable unexpectedThrowable) {
                            if (incompleteTransactionError != null) continue;
                            incompleteTransactionError = new IncompleteTransactionError(transactionSetStack.size(), unexpectedThrowable);
                        }
                    }
                    if (incompleteTransactionError != null) {
                        throw incompleteTransactionError;
                    }
                    break block10;
                }
                finally {
                    if (transactionSetStack.isEmpty()) {
                        TRANSACTION_SET_STACK_LOCAL.remove();
                    }
                }
            }
            TRANSACTION_SET_STACK_LOCAL.remove();
        }
    }
}

