/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import org.hibernate.Criteria;
import org.smallmind.persistence.orm.ORMOperationException;

public abstract class CriteriaDetails {
    private Class<?> criteriaClass;
    private String alias;

    public CriteriaDetails() {
    }

    public CriteriaDetails(String alias) {
        this.alias = alias;
    }

    public CriteriaDetails(Class<?> criteriaClass) {
        this.criteriaClass = criteriaClass;
    }

    public CriteriaDetails(Class<?> criteriaClass, String alias) {
        this.criteriaClass = criteriaClass;
        this.alias = alias;
    }

    public Class<?> getCriteriaClass(Class<?> baseClass) {
        if (this.criteriaClass == null) {
            return baseClass;
        }
        if (baseClass.isAssignableFrom(this.criteriaClass)) {
            return this.criteriaClass;
        }
        throw new ORMOperationException("The specified criteria class(%s) must be assignable from the base class(%s)", this.criteriaClass.getSimpleName(), baseClass.getSimpleName());
    }

    public String getAlias() {
        return this.alias;
    }

    public abstract Criteria completeCriteria(Criteria var1);
}

