/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import java.util.LinkedList;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.query.Sort;
import org.smallmind.persistence.query.SortField;
import org.smallmind.persistence.query.Where;
import org.smallmind.persistence.query.WhereConjunction;
import org.smallmind.persistence.query.WhereCriterion;
import org.smallmind.persistence.query.WhereField;
import org.smallmind.persistence.query.WhereFieldTransformer;
import org.smallmind.persistence.query.WhereOperandTransformer;

public class CriteriaUtility {
    public static DetachedCriteria apply(DetachedCriteria detachedCriteria, Where where) {
        return CriteriaUtility.apply(detachedCriteria, where, null, WhereOperandTransformer.instance());
    }

    public static DetachedCriteria apply(DetachedCriteria detachedCriteria, Where where, WhereFieldTransformer<Void, Void> fieldTransformer) {
        return CriteriaUtility.apply(detachedCriteria, where, fieldTransformer, WhereOperandTransformer.instance());
    }

    public static DetachedCriteria apply(DetachedCriteria detachedCriteria, Where where, WhereOperandTransformer operandTransformer) {
        return CriteriaUtility.apply(detachedCriteria, where, null, operandTransformer);
    }

    public static DetachedCriteria apply(DetachedCriteria detachedCriteria, Where where, WhereFieldTransformer<Void, Void> fieldTransformer, WhereOperandTransformer operandTransformer) {
        Criterion walkedCriterion;
        if (where != null && (walkedCriterion = CriteriaUtility.walkConjunction(where.getRootConjunction(), fieldTransformer, operandTransformer)) != null) {
            return detachedCriteria.add(walkedCriterion);
        }
        return detachedCriteria;
    }

    public static Criteria apply(Criteria criteria, Where where) {
        return CriteriaUtility.apply(criteria, where, null, WhereOperandTransformer.instance());
    }

    public static Criteria apply(Criteria criteria, Where where, WhereFieldTransformer<Void, Void> fieldTransformer) {
        return CriteriaUtility.apply(criteria, where, fieldTransformer, WhereOperandTransformer.instance());
    }

    public static Criteria apply(Criteria criteria, Where where, WhereOperandTransformer operandTransformer) {
        return CriteriaUtility.apply(criteria, where, null, operandTransformer);
    }

    public static Criteria apply(Criteria criteria, Where where, WhereFieldTransformer<Void, Void> fieldTransformer, WhereOperandTransformer operandTransformer) {
        Criterion walkedCriterion;
        if (where != null && (walkedCriterion = CriteriaUtility.walkConjunction(where.getRootConjunction(), fieldTransformer, operandTransformer)) != null) {
            return criteria.add(walkedCriterion);
        }
        return criteria;
    }

    private static Criterion walkConjunction(WhereConjunction whereConjunction, WhereFieldTransformer<Void, Void> fieldTransformer, WhereOperandTransformer operandTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Criterion> criterionList = new LinkedList<Criterion>();
        WhereCriterion[] whereCriterionArray = whereConjunction.getCriteria();
        int n = whereCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCriterion whereCriterion = whereCriterionArray[n2];
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Criterion walkedCriterion = CriteriaUtility.walkConjunction((WhereConjunction)whereCriterion, fieldTransformer, operandTransformer);
                    if (walkedCriterion == null) break;
                    criterionList.add(walkedCriterion);
                    break;
                }
                case FIELD: {
                    criterionList.add(CriteriaUtility.walkField((WhereField)whereCriterion, fieldTransformer, operandTransformer));
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
            ++n2;
        }
        if (criterionList.isEmpty()) {
            return null;
        }
        Criterion[] criteria = new Criterion[criterionList.size()];
        criterionList.toArray(criteria);
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                return Restrictions.and((Criterion[])criteria);
            }
            case OR: {
                return Restrictions.or((Criterion[])criteria);
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static Criterion walkField(WhereField whereField, WhereFieldTransformer<Void, Void> fieldTransformer, WhereOperandTransformer operandTransformer) {
        String fieldName = fieldTransformer == null ? whereField.getName() : fieldTransformer.transform(whereField.getEntity(), whereField.getName()).getField();
        Object fieldValue = operandTransformer.transform(whereField.getOperand());
        switch (whereField.getOperator()) {
            case LT: {
                return Restrictions.lt((String)whereField.getName(), fieldValue);
            }
            case LE: {
                return Restrictions.le((String)fieldName, fieldValue);
            }
            case EQ: {
                Object equalValue = fieldValue;
                return equalValue == null ? Restrictions.isNull((String)fieldName) : Restrictions.eq((String)fieldName, equalValue);
            }
            case NE: {
                Object notEqualValue = fieldValue;
                return notEqualValue == null ? Restrictions.isNotNull((String)fieldName) : Restrictions.ne((String)fieldName, notEqualValue);
            }
            case GE: {
                return Restrictions.ge((String)fieldName, fieldValue);
            }
            case GT: {
                return Restrictions.gt((String)fieldName, fieldValue);
            }
            case LIKE: {
                return Restrictions.like((String)fieldName, fieldValue);
            }
            case UNLIKE: {
                return Restrictions.not((Criterion)Restrictions.like((String)fieldName, fieldValue));
            }
            case IN: {
                return Restrictions.in((String)fieldName, (Object[])((Object[])fieldValue));
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static Criteria apply(Criteria criteria, Sort sort) {
        return CriteriaUtility.apply(criteria, sort, null);
    }

    public static Criteria apply(Criteria criteria, Sort sort, WhereFieldTransformer<Void, Void> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            SortField[] sortFieldArray = sort.getFields();
            int n = sortFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortField sortField = sortFieldArray[n2];
                String fieldName = fieldTransformer == null ? sortField.getName() : fieldTransformer.transform(sortField.getEntity(), sortField.getName()).getField();
                switch (sortField.getDirection()) {
                    case ASC: {
                        criteria.addOrder(Order.asc((String)fieldName));
                        break;
                    }
                    case DESC: {
                        criteria.addOrder(Order.desc((String)fieldName));
                        break;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
                ++n2;
            }
        }
        return criteria;
    }
}

