/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class EnumUserType
implements UserType,
ParameterizedType {
    private Class<Enum> enumClass;

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClassName");
        try {
            this.enumClass = Class.forName(enumClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Enum class not found", (Throwable)classNotFoundException);
        }
    }

    public boolean isMutable() {
        return false;
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    public Serializable disassemble(Object value) {
        return (Enum)value;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public int hashCode(Object x) {
        return x == null ? 0 : x.hashCode();
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor sessionImplementor, Object o) throws HibernateException, SQLException {
        String name = resultSet.getString(names[0]);
        return resultSet.wasNull() ? null : Enum.valueOf(this.enumClass, name);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (value == null) {
            preparedStatement.setNull(index, 12);
        } else {
            preparedStatement.setString(index, ((Enum)value).name());
        }
    }
}

