/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.orm.ORMDao;
import org.smallmind.persistence.orm.hibernate.CriteriaDetails;
import org.smallmind.persistence.orm.hibernate.HibernateDurable;
import org.smallmind.persistence.orm.hibernate.HibernateProxySession;
import org.smallmind.persistence.orm.hibernate.NativeQueryDetails;
import org.smallmind.persistence.orm.hibernate.QueryDetails;
import org.smallmind.persistence.orm.hibernate.ScrollIterable;
import org.smallmind.persistence.sql.SqlType;

public abstract class HibernateDao<I extends Serializable & Comparable<I>, D extends HibernateDurable<I, D>>
extends ORMDao<I, D, SessionFactory, Session> {
    public HibernateDao(HibernateProxySession proxySession) {
        this(proxySession, (VectoredDao<I, D>)null);
    }

    public HibernateDao(HibernateProxySession proxySession, VectoredDao<I, D> vectoredDao) {
        super(proxySession, vectoredDao);
    }

    @Override
    public D get(Class<D> durableClass, I id) {
        if (id != null) {
            VectoredDao<I, HibernateDurable> vectoredDao = this.getVectoredDao();
            if (vectoredDao == null) {
                Durable durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)durable;
                }
            } else {
                Durable durable = (HibernateDurable)vectoredDao.get(durableClass, id);
                if (durable != null) {
                    return (D)durable;
                }
                durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)vectoredDao.persist((Class<HibernateDurable>)durableClass, (HibernateDurable)durable, UpdateMode.SOFT);
                }
            }
        }
        return null;
    }

    @Override
    public D acquire(Class<D> durableClass, I id) {
        return (D)(id == null ? null : (HibernateDurable)durableClass.cast(((Session)this.getSession().getNativeSession()).get(durableClass, id)));
    }

    @Override
    public List<D> list() {
        return Collections.checkedList(((Session)this.getSession().getNativeSession()).createCriteria(this.getManagedClass()).list(), this.getManagedClass());
    }

    @Override
    public List<D> list(int maxResults) {
        return this.list((I)maxResults, maxResults);
    }

    @Override
    public List<D> list(int maxResults, int fetchSize) {
        return Collections.checkedList(((Session)this.getSession().getNativeSession()).createCriteria(this.getManagedClass()).setMaxResults(maxResults).setFetchSize(fetchSize).list(), this.getManagedClass());
    }

    @Override
    public List<D> list(I greaterThan, int maxResults) {
        return this.list(greaterThan, maxResults, maxResults);
    }

    public List<D> list(I greaterThan, int maxResults, int fetchSize) {
        return this.listByCriteria(new CriteriaDetails((Serializable)greaterThan, maxResults, fetchSize){
            private final /* synthetic */ Serializable val$greaterThan;
            private final /* synthetic */ int val$maxResults;
            private final /* synthetic */ int val$fetchSize;
            {
                this.val$greaterThan = serializable;
                this.val$maxResults = n;
                this.val$fetchSize = n2;
            }

            @Override
            public Criteria completeCriteria(Criteria criteria) {
                return criteria.add((Criterion)Restrictions.gt((String)"id", (Object)this.val$greaterThan)).addOrder(Order.asc((String)"id")).setMaxResults(this.val$maxResults).setFetchSize(this.val$fetchSize);
            }
        });
    }

    @Override
    public List<D> list(final Collection<I> idCollection) {
        if (idCollection == null || idCollection.isEmpty()) {
            return Collections.emptyList();
        }
        return this.listByCriteria(new CriteriaDetails(){

            @Override
            public Criteria completeCriteria(Criteria criteria) {
                return criteria.add(Restrictions.in((String)"id", (Collection)idCollection));
            }
        });
    }

    @Override
    public Iterable<D> scroll() {
        return new ScrollIterable(((Session)this.getSession().getNativeSession()).createCriteria(this.getManagedClass()).scroll(ScrollMode.FORWARD_ONLY), this.getManagedClass());
    }

    @Override
    public Iterable<D> scroll(int fetchSize) {
        return new ScrollIterable(((Session)this.getSession().getNativeSession()).createCriteria(this.getManagedClass()).setFetchSize(fetchSize).scroll(ScrollMode.FORWARD_ONLY), this.getManagedClass());
    }

    @Override
    public Iterable<D> scrollById(I greaterThan, int fetchSize) {
        return this.scrollByCriteria(new CriteriaDetails((Serializable)greaterThan, fetchSize){
            private final /* synthetic */ Serializable val$greaterThan;
            private final /* synthetic */ int val$fetchSize;
            {
                this.val$greaterThan = serializable;
                this.val$fetchSize = n;
            }

            @Override
            public Criteria completeCriteria(Criteria criteria) {
                return criteria.add((Criterion)Restrictions.gt((String)"id", (Object)this.val$greaterThan)).addOrder(Order.asc((String)"id")).setFetchSize(this.val$fetchSize);
            }
        });
    }

    @Override
    public long size() {
        return this.findByCriteria(Long.class, new CriteriaDetails(){

            @Override
            public Criteria completeCriteria(Criteria criteria) {
                return criteria.setProjection(Projections.rowCount());
            }
        });
    }

    public I lastId() {
        return (I)((Serializable)this.findByCriteria(this.getIdClass(), new CriteriaDetails(){

            @Override
            public Criteria completeCriteria(Criteria criteria) {
                return criteria.setProjection((Projection)Projections.max((String)"id"));
            }
        }));
    }

    @Override
    public D persist(Class<D> durableClass, D durable) {
        if (durable != null) {
            Object persistentDurable;
            VectoredDao vectoredDao = this.getVectoredDao();
            if (((Session)this.getSession().getNativeSession()).contains(durable)) {
                persistentDurable = durable;
            } else {
                persistentDurable = (HibernateDurable)this.getManagedClass().cast(((Session)this.getSession().getNativeSession()).merge(durable));
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                return (D)((HibernateDurable)vectoredDao.persist(durableClass, persistentDurable, UpdateMode.HARD));
            }
            return persistentDurable;
        }
        return null;
    }

    @Override
    public void delete(Class<D> durableClass, D durable) {
        if (durable != null) {
            VectoredDao vectoredDao = this.getVectoredDao();
            if (!((Session)this.getSession().getNativeSession()).contains(durable)) {
                HibernateDurable persistedDurable = (HibernateDurable)((Session)this.getSession().getNativeSession()).get(durableClass, ((HibernateDurable)durable).getId());
                if (persistedDurable != null) {
                    ((Session)this.getSession().getNativeSession()).delete((Object)persistedDurable);
                    this.getSession().flush();
                }
            } else {
                ((Session)this.getSession().getNativeSession()).delete(durable);
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                vectoredDao.delete(durableClass, durable);
            }
        }
    }

    @Override
    public D detach(D object) {
        throw new UnsupportedOperationException("Hibernate has no explicit detached state");
    }

    public int executeWithSQLQuery(NativeQueryDetails nativeQueryDetails) {
        return this.constructSQLQuery(nativeQueryDetails).executeUpdate();
    }

    public D findBySQLQuery(NativeQueryDetails nativeQueryDetails) {
        return (D)((HibernateDurable)this.getManagedClass().cast(this.constructSQLQuery(nativeQueryDetails).addEntity(this.getManagedClass()).uniqueResult()));
    }

    public <T> T findBySQLQuery(Class<T> returnType, NativeQueryDetails nativeQueryDetails) {
        SQLQuery sqlQuery = this.constructSQLQuery(nativeQueryDetails);
        if (Durable.class.isAssignableFrom(returnType)) {
            return returnType.cast(sqlQuery.addEntity(returnType).uniqueResult());
        }
        if (!SqlType.isKnownType(returnType)) {
            return returnType.cast(sqlQuery.setResultTransformer(Transformers.aliasToBean(returnType)).uniqueResult());
        }
        Object obj = sqlQuery.uniqueResult();
        if (obj != null) {
            return returnType.cast(obj);
        }
        return null;
    }

    public List<D> listBySQLQuery(NativeQueryDetails nativeQueryDetails) {
        return Collections.checkedList(this.constructSQLQuery(nativeQueryDetails).addEntity(this.getManagedClass()).list(), this.getManagedClass());
    }

    public <T> List<T> listBySQLQuery(Class<T> returnType, NativeQueryDetails nativeQueryDetails) {
        SQLQuery sqlQuery = this.constructSQLQuery(nativeQueryDetails);
        if (Durable.class.isAssignableFrom(returnType)) {
            return Collections.checkedList(sqlQuery.addEntity(returnType).list(), returnType);
        }
        if (!SqlType.isKnownType(returnType)) {
            return Collections.checkedList(sqlQuery.setResultTransformer(Transformers.aliasToBean(returnType)).list(), returnType);
        }
        LinkedList<T> returnList = new LinkedList<T>();
        for (Object obj : sqlQuery.list()) {
            returnList.add(returnType.cast(obj));
        }
        return returnList;
    }

    public Iterable<D> scrollBySQLQuery(NativeQueryDetails nativeQueryDetails) {
        return new ScrollIterable(this.constructSQLQuery(nativeQueryDetails).addEntity(this.getManagedClass()).scroll(ScrollMode.FORWARD_ONLY), this.getManagedClass());
    }

    public int executeWithQuery(QueryDetails queryDetails) {
        return this.constructQuery(queryDetails).executeUpdate();
    }

    public <T> T findByQuery(Class<T> returnType, QueryDetails queryDetails) {
        return returnType.cast(this.constructQuery(queryDetails).uniqueResult());
    }

    public D findByQuery(QueryDetails queryDetails) {
        return (D)((HibernateDurable)this.getManagedClass().cast(this.constructQuery(queryDetails).uniqueResult()));
    }

    public <T> List<T> listByQuery(Class<T> returnType, QueryDetails queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).list(), returnType);
    }

    public List<D> listByQuery(QueryDetails queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).list(), this.getManagedClass());
    }

    public <T> Iterable<T> scrollByQuery(Class<T> returnType, QueryDetails queryDetails) {
        return new ScrollIterable<T>(this.constructQuery(queryDetails).scroll(ScrollMode.FORWARD_ONLY), returnType);
    }

    public Iterable<D> scrollByQuery(QueryDetails queryDetails) {
        return new ScrollIterable(this.constructQuery(queryDetails).scroll(ScrollMode.FORWARD_ONLY), this.getManagedClass());
    }

    public <T> T findByCriteria(Class<T> returnType, CriteriaDetails criteriaDetails) {
        return returnType.cast(this.constructCriteria(criteriaDetails).uniqueResult());
    }

    public D findByCriteria(CriteriaDetails criteriaDetails) {
        return (D)((HibernateDurable)this.getManagedClass().cast(this.constructCriteria(criteriaDetails).uniqueResult()));
    }

    public <T> List<T> listByCriteria(Class<T> returnType, CriteriaDetails criteriaDetails) {
        return Collections.checkedList(this.constructCriteria(criteriaDetails).list(), returnType);
    }

    public List<D> listByCriteria(CriteriaDetails criteriaDetails) {
        return Collections.checkedList(this.constructCriteria(criteriaDetails).list(), this.getManagedClass());
    }

    public <T> Iterable<T> scrollByCriteria(Class<T> returnType, CriteriaDetails criteriaDetails) {
        return new ScrollIterable<T>(this.constructCriteria(criteriaDetails).scroll(ScrollMode.FORWARD_ONLY), returnType);
    }

    public Iterable<D> scrollByCriteria(CriteriaDetails criteriaDetails) {
        return new ScrollIterable(this.constructCriteria(criteriaDetails).scroll(ScrollMode.FORWARD_ONLY), this.getManagedClass());
    }

    public SQLQuery constructSQLQuery(NativeQueryDetails nativeQueryDetails) {
        return nativeQueryDetails.completeNativeQuery((SQLQuery)((Session)this.getSession().getNativeSession()).createSQLQuery(nativeQueryDetails.getNativeQueryString()).setCacheable(true));
    }

    public Query constructQuery(QueryDetails queryDetails) {
        return queryDetails.completeQuery(((Session)this.getSession().getNativeSession()).createQuery(queryDetails.getQueryString()).setCacheable(true));
    }

    private Criteria constructCriteria(CriteriaDetails criteriaDetails) {
        Criteria criteria = criteriaDetails.getAlias() == null ? ((Session)this.getSession().getNativeSession()).createCriteria(criteriaDetails.getCriteriaClass(this.getManagedClass())) : ((Session)this.getSession().getNativeSession()).createCriteria(criteriaDetails.getCriteriaClass(this.getManagedClass()), criteriaDetails.getAlias());
        return criteriaDetails.completeCriteria(criteria).setCacheable(true);
    }

    public DetachedCriteria detachCriteria() {
        return DetachedCriteria.forClass(this.getManagedClass());
    }
}

