/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.SessionEnforcementException;
import org.smallmind.persistence.orm.aop.BoundarySet;
import org.smallmind.persistence.orm.aop.NonTransactionalState;
import org.smallmind.persistence.orm.aop.RollbackAwareBoundarySet;
import org.smallmind.persistence.orm.aop.TransactionalState;
import org.smallmind.persistence.orm.hibernate.HibernateProxyTransaction;

public class HibernateProxySession
extends ProxySession<SessionFactory, Session> {
    private final ThreadLocal<Session> managerThreadLocal = new ThreadLocal();
    private final ThreadLocal<HibernateProxyTransaction> transactionThreadLocal = new ThreadLocal();
    private final SessionFactory sessionFactory;

    public HibernateProxySession(String dataSourceType, String sessionSourceKey, SessionFactory sessionFactory, boolean boundaryEnforced, boolean cacheEnabled) {
        super(dataSourceType, sessionSourceKey, boundaryEnforced, cacheEnabled);
        this.sessionFactory = sessionFactory;
    }

    @Override
    public HibernateProxyTransaction beginTransaction() {
        HibernateProxyTransaction proxyTransaction = this.transactionThreadLocal.get();
        if (proxyTransaction == null) {
            Session session = this.getSession();
            proxyTransaction = this.transactionThreadLocal.get();
            if (proxyTransaction == null) {
                proxyTransaction = new HibernateProxyTransaction(this, session.beginTransaction());
                this.transactionThreadLocal.set(proxyTransaction);
            }
        }
        return proxyTransaction;
    }

    @Override
    public ProxyTransaction currentTransaction() {
        return this.transactionThreadLocal.get();
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public void clear() {
        this.getSession().clear();
    }

    @Override
    public boolean isClosed() {
        Session session = this.managerThreadLocal.get();
        return session == null || !session.isOpen();
    }

    @Override
    public SessionFactory getNativeSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Session getNativeSession() {
        return this.getSession();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session getSession() {
        Session session;
        do {
            if ((session = this.managerThreadLocal.get()) == null) {
                session = this.sessionFactory.openSession();
                this.managerThreadLocal.set(session);
                RollbackAwareBoundarySet<ProxyTransaction> transactionSet = TransactionalState.obtainBoundary(this);
                if (transactionSet != null) {
                    try {
                        transactionSet.add(this.beginTransaction());
                    }
                    catch (Throwable throwable) {
                        this.close();
                        throw new SessionEnforcementException(throwable);
                    }
                } else {
                    BoundarySet<ProxySession> sessionSet = NonTransactionalState.obtainBoundary(this);
                    if (sessionSet != null) {
                        sessionSet.add(this);
                        continue;
                    }
                    if (!this.isBoundaryEnforced()) continue;
                    this.close();
                    throw new SessionEnforcementException("Session was requested outside of any boundary enforcement (@NonTransactional or @Transactional)", new Object[0]);
                }
            }
            if (session.isConnected()) continue;
            session = null;
            this.managerThreadLocal.set(null);
            this.transactionThreadLocal.set(null);
        } while (session == null);
        return session;
    }

    @Override
    public void close() {
        try {
            Session session = this.managerThreadLocal.get();
            if (session != null) {
                session.close();
            }
        }
        finally {
            this.managerThreadLocal.set(null);
            this.transactionThreadLocal.set(null);
        }
    }
}

