/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.smallmind.nutsnbolts.lang.ThrowableUtility;
import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.ProxyTransactionException;
import org.smallmind.persistence.orm.TransactionEndState;
import org.smallmind.persistence.orm.TransactionPostProcessException;
import org.smallmind.persistence.orm.hibernate.HibernateProxySession;

public class HibernateProxyTransaction
extends ProxyTransaction<HibernateProxySession> {
    private Transaction transaction;
    private boolean rolledBack = false;

    public HibernateProxyTransaction(HibernateProxySession proxySession, Transaction transaction) {
        super(proxySession);
        this.transaction = transaction;
    }

    @Override
    public boolean isCompleted() {
        return !TransactionStatus.ACTIVE.equals((Object)this.transaction.getStatus());
    }

    @Override
    public void flush() {
        ((HibernateProxySession)this.getSession()).flush();
    }

    @Override
    public void commit() {
        if (this.isRollbackOnly()) {
            this.rollback((Throwable)((Object)new ProxyTransactionException("Transaction has been set to allow rollback only", new Object[0])));
        } else {
            block11: {
                if (!((HibernateProxySession)this.getSession()).getNativeSession().isConnected()) {
                    throw new ProxyTransactionException("The current Transaction can't commit because the Session is no longer open", new Object[0]);
                }
                try {
                    try {
                        ((HibernateProxySession)this.getSession()).flush();
                        this.transaction.commit();
                    }
                    catch (Throwable throwable) {
                        this.rollback(throwable);
                        ((HibernateProxySession)this.getSession()).close();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    ((HibernateProxySession)this.getSession()).close();
                    throw throwable;
                }
                ((HibernateProxySession)this.getSession()).close();
            }
            if (!this.rolledBack) {
                try {
                    this.applyPostProcesses(TransactionEndState.COMMIT);
                }
                catch (TransactionPostProcessException transactionPostProcessException) {
                    throw new ProxyTransactionException((Throwable)((Object)transactionPostProcessException));
                }
            }
        }
    }

    @Override
    public void rollback() {
        this.rollback(null);
    }

    private void rollback(Throwable thrownDuringCommit) {
        Object thrownDuringRollback = thrownDuringCommit;
        if (!this.rolledBack) {
            block15: {
                this.rolledBack = true;
                if (!((HibernateProxySession)this.getSession()).getNativeSession().isConnected()) {
                    throw new ProxyTransactionException("The current Transaction can't rollback because the Session is no longer open", new Object[0]);
                }
                try {
                    try {
                        this.transaction.rollback();
                    }
                    catch (Throwable throwable) {
                        thrownDuringRollback = thrownDuringRollback == null ? throwable : ThrowableUtility.attach((Throwable)throwable, (Throwable)thrownDuringRollback);
                        ((HibernateProxySession)this.getSession()).close();
                        try {
                            this.applyPostProcesses(TransactionEndState.ROLLBACK);
                        }
                        catch (TransactionPostProcessException transactionPostProcessException) {
                            thrownDuringRollback = thrownDuringRollback == null ? new ProxyTransactionException((Throwable)((Object)transactionPostProcessException)) : new ProxyTransactionException((Throwable)((Object)transactionPostProcessException)).initCause((Throwable)thrownDuringRollback);
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    ((HibernateProxySession)this.getSession()).close();
                    try {
                        this.applyPostProcesses(TransactionEndState.ROLLBACK);
                    }
                    catch (TransactionPostProcessException transactionPostProcessException) {
                        thrownDuringRollback = thrownDuringRollback == null ? new ProxyTransactionException((Throwable)((Object)transactionPostProcessException)) : new ProxyTransactionException((Throwable)((Object)transactionPostProcessException)).initCause((Throwable)thrownDuringRollback);
                    }
                    throw throwable;
                }
                ((HibernateProxySession)this.getSession()).close();
                try {
                    this.applyPostProcesses(TransactionEndState.ROLLBACK);
                }
                catch (TransactionPostProcessException transactionPostProcessException) {
                    Object object = thrownDuringRollback = thrownDuringRollback == null ? new ProxyTransactionException((Throwable)((Object)transactionPostProcessException)) : new ProxyTransactionException((Throwable)((Object)transactionPostProcessException)).initCause((Throwable)thrownDuringRollback);
                }
            }
            if (thrownDuringRollback != null) {
                if (thrownDuringRollback instanceof ProxyTransactionException) {
                    throw (ProxyTransactionException)((Object)thrownDuringRollback);
                }
                throw new ProxyTransactionException((Throwable)thrownDuringRollback);
            }
        }
    }
}

