/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class ObjectUserType
implements UserType,
ParameterizedType {
    private Class<?> embeddedClass;

    public void setParameterValues(Properties parameters) {
        String objectClassName = parameters.getProperty("embeddedClassName");
        try {
            this.embeddedClass = Class.forName(objectClassName);
            if (!Serializable.class.isAssignableFrom(this.embeddedClass)) {
                throw new HibernateException("Embedded class(" + this.embeddedClass + ") must be Serializable");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException((Throwable)classNotFoundException);
        }
    }

    public boolean isMutable() {
        return false;
    }

    public Class returnedClass() {
        return this.embeddedClass;
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    public int hashCode(Object x) {
        return x == null ? 0 : x.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor sessionImplementor, Object o) throws HibernateException, SQLException {
        byte[] bytes = resultSet.getBytes(names[0]);
        try {
            return resultSet.wasNull() ? null : new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (value == null) {
            preparedStatement.setNull(index, -3);
        } else {
            ByteArrayOutputStream byteStream;
            try {
                byteStream = new ByteArrayOutputStream();
                new ObjectOutputStream(byteStream).writeObject(value);
            }
            catch (IOException ioException) {
                throw new HibernateException((Throwable)ioException);
            }
            preparedStatement.setBytes(index, byteStream.toByteArray());
        }
    }
}

